﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter.Statistik;
using WK5.Core.PageModels.Tools;
using WK5.Core.Services;

namespace WK5_Blazor.Pages.Statistik
{
    public partial class ErloesKalkulator
    {
        private bool isSortedAscending;
        private string? activeSortColumn;
        private string sortIcon = "arrow-down";
        public ErlöskalkulatorFilter Input { get; set; } = new ErlöskalkulatorFilter();

        public List<ErlöskalkulatorResult> Daten { get; set; } = new List<ErlöskalkulatorResult>();

        private bool sperre = false;

        private async Task LadeÜbersicht()
        {
            sperre = true;
            
            using FbController2 fbController = new FbController2();
            Daten = await service.GetBelegeAsync(Input, fbController);

            sperre = false;
        }

        protected override async Task OnAfterRenderAsync(bool firstRender)
        {
            if (firstRender)
            {
                await LadeÜbersicht();

                StateHasChanged();
            }
        }

        private void SortTable(string columnName)
        {
            if (columnName != activeSortColumn)
            {
                Daten = Daten.OrderBy(x => x.GetType().GetProperty(columnName)!.GetValue(x, null)).ToList();
                isSortedAscending = true;
                activeSortColumn = columnName;
            }
            else
            {
                if (isSortedAscending)
                {
                    Daten = Daten.OrderByDescending(x => x.GetType()!.GetProperty(columnName)!.GetValue(x, null)).ToList();
                }
                else
                {
                    Daten = Daten.OrderBy(x => x.GetType()!.GetProperty(columnName)!.GetValue(x, null)).ToList();
                }
                isSortedAscending = !isSortedAscending;
            }

            sortIcon = isSortedAscending ? "fas fa-arrow-up" : "fas fa-arrow-down";
        }

        private async Task ErgebnisDrucken()
        {
            sperre = true;
            StateHasChanged();
            List<ErlöskalkulatorResult> results = Daten.Select(x => x).ToList();

            StringBuilder sb = new StringBuilder();
            sb.AppendLine("Typ;Belegnummer;EK;VK;Roherlös;Gewinnprozent;Vertreter;Letzter Bearbeiter");
            foreach (ErlöskalkulatorResult res in results)
            {
                string vertreter = Program.AppDaten.GetVertreterName(res.BELE_N_VERTRETER);
                

                string letzterBearbeiter = Program.AppDaten.GetMitarbeiterName(res.BELE_N_LASTUSER);
                

                sb.AppendLine($"{res.BELE_A_TYP};{res.BELE_N_NR};{String.Format("{0:C}", Math.Round(res.EK, 2))};{String.Format("{0:C}", Math.Round(res.VK, 2))};{String.Format("{0:C}", Math.Round(res.Erlös, 2))};{Math.Round(res.GewinnProzent, 2).ToString("#.00", CultureInfo.InvariantCulture)}%;{vertreter};{letzterBearbeiter}");
            }
            await downloadService.DownloadFileFromText("erloeskalkulator.csv", sb.ToString(), Encoding.UTF8,"text/csv");
            sperre = false;
        }


    }
}
