﻿using System.Linq;
using System.Collections.Generic;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter.Statistik;
using WK5.Core.Models.Statistik;

namespace WK5_Blazor.Pages.Statistik
{
    public partial class EARStatistik
    {
        public EARStatistikFilter Filter { get; set; } = new EARStatistikFilter();
        private bool _lädt { get; set; }
        public List<EARStatistikResult> _results { get; set; } = new List<EARStatistikResult>();
        private async Task LadeAsync()
        {
            _results.Clear();
            _lädt = true;
            using FbController2 fbController = new FbController2();
            _results = await statistikService.GetEARStatistik(Filter, fbController);
            _lädt = false;
        }

        private async Task RemoveAsync(EARStatistikResult result)
        {
            _results.RemoveAll(x => x.Artikelnummer.Equals(result.Artikelnummer));
            using FbController2 fbController = new FbController2();
            await artikelService.KeineElektronikFlagSetzenAsync(result.Artikelnummer, true, fbController);
        }

        private decimal GetGesamtGewicht()
        {
            return _results.Sum(x => x.Menge * x.Gewicht);
        }
    }
}
