﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;
using WK5.Core.PageModels.Stammdaten.Lieferanten;
using WK5_Blazor.CoreExtensions;

namespace WK5_Blazor.Pages.Stammdaten.Lieferanten
{
    public partial class LieferantenÜbersicht : IHasPageFilter, IDisposable
    {
        private int _selectedLieferantenId;
        private CancellationTokenSource _ctsSuche = new CancellationTokenSource();

        private List<LieferantenPartnerInput> LieferantenPartnerInputs { get; } = new List<LieferantenPartnerInput>();
        private bool _lädtLieferantenPartner;
        private CancellationTokenSource _ctsLieferantenPartner = new CancellationTokenSource();
        public bool _showLieferantenPartner { get; set; } = false;
        public bool _showLieferantenKontakte { get; set; } = false;
        private bool _lädt = false;
        private Task ShowLieferantenKontakte(int lieferantenId)
        {
            
            _selectedLieferantenId = lieferantenId;
            _showLieferantenKontakte = true;

            return Task.CompletedTask;
        }

        private async Task ShowLieferantenPartner(int lieferantenId)
        {
            _ctsLieferantenPartner.Cancel();
            _ctsLieferantenPartner = new CancellationTokenSource();
            _selectedLieferantenId = lieferantenId;
            _showLieferantenPartner = true;
            LieferantenPartnerInputs.Clear();
            _lädtLieferantenPartner = true;
            await Task.Run(async () =>
            {
                await foreach (var partner in LieferantenPartner.GetLieferantenPartnerAsync(lieferantenId))
                {
                    LieferantenPartnerInputs.Add(partner.ToInput());
                    await InvokeAsync(StateHasChanged);
                }
            }, _ctsLieferantenPartner.Token);


            _lädtLieferantenPartner = false;
        }

        public LieferantenFilter Filter { get; set; } = new LieferantenFilter();

        private int _seite = 1;

        [Parameter]
        public int Seite
        {
            get => _seite;
            set
            {
                if (value <= 0)
                {
                    value = 1;
                }

                _seite = value;
            }
        }

        public int TotalItems { get; set; }

        public List<Lieferant> Übersicht { get; set; } = new List<Lieferant>();

        private bool showLieferantenDetailsModals;
        private LieferantenDetails? lieferantenDetails;


        public const string LocalStorageFilterKey = "LieferantenÜbersicht.Filter";
        protected override async Task OnInitializedAsync()
        {
            await SetAlerts();
        }
        protected override async Task OnParametersSetAsync()
        {

            var localStorageResult = await LocalStorage.GetAsync<LieferantenFilter>(LocalStorageFilterKey);
            if (localStorageResult.Success)
            {
                if (localStorageResult.Value is not null)
                {
                    Filter = localStorageResult.Value;
                }
            }
            await LadeÜbersicht();

        }

        /// <summary>
        /// Lädt die Kunden in die Übersicht
        /// </summary>
        /// <returns>Gibt einen leeren Task zurück</returns>
        private async Task LadeÜbersicht(bool navigateToPage1 = false)
        {
            if (_lädt)
                return;
            _lädt = true;
            _ctsSuche.Cancel();
            _ctsSuche = new CancellationTokenSource();

            if (navigateToPage1)
            {
                navigationManager.NavigateTo("/Lieferanten");
            }
            Filter.Seite = Seite;
            Übersicht.Clear();
            await LocalStorage.SetAsync(LocalStorageFilterKey, Filter);
            TotalItems = await lieferantenService.GetAnzahlLieferantenAsync(Filter, _ctsSuche.Token);


            await foreach (var lieferant in lieferantenService.GetLieferantenAsync(Filter, _ctsSuche.Token))
            {
                if (!(lieferant is null))
                {
                    Übersicht.Add(lieferant);
                    StateHasChanged();
                }
            }
            _lädt = false;
        }

        private async Task ShowLieferantenDetails(Lieferant lieferant)
        {
            lieferantenDetails = await lieferantenService.GetLieferantenDetailsAsync(lieferant.LIEF_N_NR);
            showLieferantenDetailsModals = true;
        }

        public void Dispose()
        {
            _ctsSuche.Cancel();   
            _ctsSuche.Dispose();
        }
    }
}
