﻿using Microsoft.AspNetCore.Components;
using Microsoft.JSInterop;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Models;

namespace WK5_Blazor.Pages.Stammdaten.Lieferanten
{
    public partial class Kontakt
    {
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        [Parameter] public int LieferantenKontaktId { get; set; }
        private LieferantenKontakt? Input { get; set; }
        private Lieferant? lieferant { get; set; }

        protected override async Task OnParametersSetAsync()
        {
            if (LieferantenKontaktId > 0)
            {
                using FbController2 fbController = new FbController2();
                LieferantenKontakt? lfko = await lieferantenkontaktService.GetAsync(LieferantenKontaktId, fbController);

                if (lfko is not null)
                {
                    Input = lfko;
                    lieferant = await Lieferant.GetLieferantAsync(lfko.LFKO_N_LFNR);
                }


            }
        }

        public async Task AfterEdit()
        {
            await JSRuntime.InvokeAsync<object>("window.close");
        }
    }
}
