﻿using Microsoft.AspNetCore.Components;
using Microsoft.JSInterop;
using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Models;

namespace WK5_Blazor.Pages.Stammdaten.Kunden
{
    public partial class Kontakt
    {
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        [Parameter] public int KundenkontaktId { get; set; }
        private Kundenkontakt Input { get; set; } = new();
        private Kunde? kunde { get; set; }

        protected override async Task OnParametersSetAsync()
        {
            if (KundenkontaktId > 0)
            {
                using FbController2 fbController = new FbController2();
                Kundenkontakt? kontakt = await kundenkontaktService.GetAsync(KundenkontaktId, fbController);

                if (kontakt is not null)
                {
                    Input = kontakt;
                    kunde = await Kunde.GetKundeAsync(kontakt.KUKO_A_KUNDNR);
                }


            }
        }

        public async Task AfterEdit()
        {
            await JSRuntime.InvokeAsync<object>("window.close");
        }
    }
}
