﻿using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Forms;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;
using WK5.Core.Models.Lager;

namespace WK5_Blazor.Pages.Stammdaten.Artikeldaten
{
    public partial class Lagerabwertung 
    {
        [Parameter] public string Artikelnummer { get; set; } = string.Empty;
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable

        private ChargenFilter _chargenFilter  = new ChargenFilter
        {
            NurOffene = true
        };

        private SeriennummerFilter _seriennummerFilter = new SeriennummerFilter
        {
            NurNichtAusgelieferte = true
        };

        public LagerabwertungInput Input { get; set; } = new LagerabwertungInput();

        private EditForm? _editForm;
        protected override async Task OnParametersSetAsync()
        {
            using FbController2 fbController = new FbController2();
            Artikel? artikel = await artikelService.GetAsync(Artikelnummer, fbController);

            if(artikel is not null)
            {
                _chargenFilter.Artikelnummer = artikel.Artikelnummer;
                _seriennummerFilter.Artikelnummer = artikel.Artikelnummer;
                Input.BenötigtSeriennummer = artikel.ARTI_L_SN;
                Input.Artikelnummer = artikel.Artikelnummer;
            }
        }

        private async Task SaveAsync()
        {
            if(_editForm is null || _editForm.EditContext is null)
            {
                return;
            }

            if(_editForm.EditContext.Validate())
            {
                using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
                await fbController.StartTransactionAsync();
                try
                {
                    await lagerService.ChargeAbwertenAsync(Input, fbController, chargenService);
                    await fbController.CommitChangesAsync();

                    await AddAlertAsync(new AlertBox
                    {
                        AlertType = AlertType.Success,
                        Message = "Lagerabwertung war erfolgreich.",
                        DecayTime = 5000
                    });

                    navigationManager.NavigateTo($"/Artikel/{Artikelnummer}");

                }
                catch (Exception)
                {
                    await fbController.RollbackChangesAsync();
                    throw;
                }
            }
        }

        private Task OnChargeSelected(Charge charge)
        {
            Input.Charge = charge.CHAR_N_NR;
            Input.MaxMenge = charge.CHAR_N_MENGEOFFEN;
            Input.Preis = charge.CHAR_N_EKPREIS;
            Input.MaxPreis = charge.CHAR_N_EKPREIS;
            return Task.CompletedTask;
        }

        private Task OnChargenModalClosed()
        {
            if (Input.Charge is 0)
            {
                navigationManager.NavigateTo("/Artikel");
            }

            return Task.CompletedTask;
        }

        private async Task OnSeriennummerSelected(Seriennummer seriennummer)
        {
            Input.MaxMenge = 1;
            Input.Menge = 1;
            Input.Seriennummer = seriennummer.Nummer;
            Input.Charge = seriennummer.Charge;

            using FbController2 fbController = new FbController2();
            Charge charge = await Charge.GetChargeAsync(seriennummer.Charge, fbController) ?? throw new NullReferenceException(nameof(charge));

            Input.Preis = charge.CHAR_N_EKPREIS;
            Input.MaxPreis = charge.CHAR_N_EKPREIS;
        }

        private Task OnSeriennummerModalClosed()
        {
            if (Input.Charge is 0 || String.IsNullOrWhiteSpace(Input.Seriennummer))
            {
                navigationManager.NavigateTo("/Artikel");
            }

            return Task.CompletedTask;
        }
    }
}
