#define UseWeightSearch
using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Server.ProtectedBrowserStorage;
using Microsoft.JSInterop;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;
using MArtikel = WK5.Core.Models.ArtikelÜbersicht;

namespace WK5_Blazor.Pages.Stammdaten.Artikeldaten
{
    public partial class ArtikelÜbersicht : IHasPageFilter, IAsyncDisposable
    {
        public List<MArtikel> Übersicht { get; set; } = new List<MArtikel>();

        public ArtikelFilter Filter { get; set; } = new ArtikelFilter();

        private CancellationTokenSource cancellationToken = new CancellationTokenSource();

        private MArtikel? _neuesAngebotArtikel;
        private bool _showHilfeModal = false;

#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable

        private int _seite = 1;
        [Parameter]
        public int Seite
        {
            get => _seite;
            set
            {
                if (value <= 0)
                {
                    value = 1;
                }

                _seite = value;
            }
        }

        public int TotalItems { get; set; }

        private bool _showArtikelDetails { get; set; } = false;
        private MArtikel? _detailArtikel { get; set; } = null;

        public bool _lädt { get; set; } = false;
        public bool showLieferantenSucheModal { get; set; } = false;

        private string _sortIcon => _isSortedDescending ? "fas fa-sort-amount-down" : "fas fa-sort-amount-up-alt";
        private bool _isSortedDescending = false;
        private string? _activeSortColumn;
        private string _headerClass = "th-sort text-nowrap";
        private bool _isDisposed;

        public const string LocalStorageFilterKey = "ArtkielÜbersicht.Filter";



        public Task LieferantSelected(Lieferant lief)
        {
            Filter.SelectedLieferant = lief;
            Filter.LieferantenId = lief.LIEF_N_NR;
            showLieferantenSucheModal = false;
            StateHasChanged();
            return Task.CompletedTask;
        }


        private List<Preisliste> preislisten = new List<Preisliste>();

        public async Task UpdateWichtigkeit(string artikelnummer)
        {
            await artikelService.UpdateWichtigkeitAsync(artikelnummer);
        }

        private async Task CreateAngebotAsync()
        {
            if (_neuesAngebotArtikel is null)
            {
                return;
            }
            using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
            Angebot angebot = await Angebot.GetAngebotAsync(_neuesAngebotArtikel.Angebotsvorlage, fbController) ?? throw new ArgumentNullException(nameof(angebot));
            Kunde kunde = await Kunde.GetKundeAsync(angebot.Kundennummer) ?? throw new ArgumentNullException(nameof(kunde));
            var (NeuerBeleg, Messages) = await belegService.CopyAsync(angebot, kunde, Program.AppDaten.Optionen, fbController, Mitarbeiter.PersonalNummer);

            await AddAlertsAsync(Messages);
            navigationManager.NavigateTo($"/Angebote/{NeuerBeleg.Belegnummer}");
        }
        public async Task LadeÜbersicht(bool navigateToPage1 = false, string? columnName = null)
        {
            if (_lädt)
            {
                return;
            }

            _lädt = true;
            if (navigateToPage1)
            {
                Seite = 1;
            }
            Übersicht.Clear();
            cancellationToken = new CancellationTokenSource();
            Filter.Seite = Seite;

            if (!String.IsNullOrWhiteSpace(columnName))
            {
                if (columnName.Equals(_activeSortColumn))
                {
                    _isSortedDescending = !_isSortedDescending;
                    Filter.OrderDescending = _isSortedDescending;
                    Filter.SuchAttribut = columnName;
                }
                else
                {
                    _isSortedDescending = true;
                    Filter.OrderDescending = _isSortedDescending;
                    Filter.SuchAttribut = columnName;
                }
                _activeSortColumn = columnName;
            }

            await LocalStorage.SetAsync(LocalStorageFilterKey, Filter);
            var token = cancellationToken.Token;

            Filter.Seite = Seite;
            try
            {
                TotalItems = await artikelService.GetArtikelAnzahlAsync(Filter, token);


                await foreach (var übersicht in artikelService.GetArtikelÜbersichtAsync(Filter, token))
                {
                    Übersicht.Add(übersicht);
                    StateHasChanged();
                }

            }
            catch (OperationCanceledException) { }
            catch (Exception)
            {
                Filter = new ArtikelFilter();
                await LocalStorage.SetAsync(LocalStorageFilterKey, Filter);
                throw;
            }

            _lädt = false;
        }

        protected override async Task OnInitializedAsync()
        {
            await SetAlerts();
        }
        protected override async Task OnParametersSetAsync()
        {
            if (!_isDisposed)
            {
                var localStorageResult = await LocalStorage.GetAsync<ArtikelFilter>(LocalStorageFilterKey);
                if (localStorageResult.Success)
                {
                    if (localStorageResult.Value is not null)
                    {
                        Filter = localStorageResult.Value;
                    }
                }

                await LadeÜbersicht();
            }
        }

        private ArtikelDetails? artikelDetails { get; set; }


        public Warengruppe? DetailWarengruppe { get; set; }
        public Unterwarengruppe? DetailUnterwarengruppe { get; set; }
        private async Task ShowArtikelDetails(MArtikel artikel)
        {
            if (!String.IsNullOrWhiteSpace(artikel.ARTU_A_WARENGRUPPE))
            {
                DetailWarengruppe = await Warengruppe.GetWarengruppeAsync(artikel.ARTU_A_WARENGRUPPE);
            }

            if (!String.IsNullOrWhiteSpace(artikel.ARTU_A_WARENGRUPPE) && !String.IsNullOrWhiteSpace(artikel.ARTU_A_UNTERWARENGRUPPE))
            {
                DetailUnterwarengruppe = await Unterwarengruppe.GetUnterwarengruppeAsync(artikel.ARTU_A_WARENGRUPPE, artikel.ARTU_A_UNTERWARENGRUPPE);
            }

            artikelDetails = await artikelService.GetArtikelDetailsAsync(artikel.ARTU_A_NR);
            _detailArtikel = artikel;
        }

        private string GetRowClass(MArtikel artikel)
        {
            if (artikel.ARTU_L_INAKTIV)
            {
                return "table-danger";
            }
            else
            {
                return String.Empty;
            }
        }


        

        private async Task<string> OnBedarfShown(MArtikel artikel)
        {
            string bedarf = "<ul>";
            await foreach (int nr in artikelService.GetBelegBedarf(artikel.ARTU_A_NR))
            {
                bedarf += $"<li><a href=\"/Auftraege/{nr}\" target=\"_blank\">AU-{nr}</a></li>";
            }

            bedarf += "</ul>";

            return bedarf;
            //StateHasChanged();
        }
        
        private async Task<string> OnBestellungShown(MArtikel artikel)
        {

            string bestellungen = "<ul>";
            await foreach (int nr in bestellService.GetOffeneBestellungenFürArtikelAsync(artikel.ARTU_A_NR))
            {
                bestellungen += $"<li><a href='/Bestellungen/{nr}' target='_blank'>{nr}</a></li>";

            }

            bestellungen += "</ul>";

            return bestellungen;
            //StateHasChanged();
        }

        private Task WarengruppeChangedAsync(string warengruppe)
        {
            Filter.Warengruppe = warengruppe;
            Filter.Unterwarengruppe = string.Empty;
            return Task.CompletedTask;
        }


        public override ValueTask DisposeAsync()
        {
            cancellationToken?.Cancel();
            cancellationToken?.Dispose();
            _isDisposed = true;

            return base.DisposeAsync();
        }
    }
}
