﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Models.Tools.Lagerregal;

namespace WK5_Blazor.Pages.Lagerregal
{
    public partial class Stückliste
    {
        [Parameter] public int Belegnummer { get; set; }
        [Parameter] public int PosId { get; set; }
        [Parameter] public string? StklPosId { get; set; }

        public PackAuftrag? Auftrag { get; set; }
        public PackBelegposition? Position { get; set; }
        protected override async Task OnParametersSetAsync()
        {
            // FbController wird neu erstellt, um Probleme zu umgehen, da die Methode zweimal aufgerufen wird
            using FbController2 fbController = new FbController2();
            Auftrag = await PackAuftrag.GetPackAuftragAsync(Belegnummer, fbController);
            Position = Auftrag?.GetPosition(PosId);

            if (Position is null)
            {
                navigationManager.NavigateTo("/404");
                return;
            }

            if (StklPosId != null)
            {
                string[] stklPositionenStrArr = StklPosId.Split('_');

                List<int> stklPosIds = new List<int>();

                foreach (string stklPosStr in stklPositionenStrArr)
                {
                    _ = int.TryParse(stklPosStr, out int stklPosId);
                    if (stklPosId != 0)
                    {
                        stklPosIds.Add(stklPosId);
                    }
                }


                int stklPositionsId = stklPosIds.Last();
                Position = Auftrag?.GetPosition(Position, stklPositionsId);
                if (Position == null)
                {
                    navigationManager.NavigateTo("/404");
                    return;
                }
            }

            if (Position is null)
            {
                navigationManager.NavigateTo("/404");
                return;
            }

            if (!Position.PositionIstStückliste)
            {

            }
        }
    }
}
