using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Components;
using System.Net.Http;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Components.Authorization;
using Microsoft.AspNetCore.Components.Forms;
using Microsoft.AspNetCore.Components.Routing;
using Microsoft.AspNetCore.Components.Web;
using Microsoft.JSInterop;
using WK5_Blazor;
using WK5_Blazor.Components;
using WK5_Blazor.Components.Lieferanten;
using WK5.Core;
using WK5.Core.Models;
using WK5.Core.Models.Tools.Lagerregal;
using WK5.Core.Models.Tools.AdressReminder;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Services;
using WK5_Blazor.Components.Modals;
using WK5.Core.Basis;
using WK5.Core.Models.Versand;
using WK5.Core.PageModels.Tools.Versand;
using WK5_Blazor.PageModels;
using KarleyLibrary.Erweiterungen;
using Microsoft.AspNetCore.Components.Web.Extensions.Head;
using ChartJs.Blazor;
using Radzen;
using Radzen.Blazor;
using BlazorDownloadFile;
using WK5_Blazor.Components.Suchen;
using WK5_Blazor.Authorization;
using Microsoft.AspNetCore.Components.Web.Virtualization;
using WK5.Core.PageModels;
using BlazorWheelZoomLibrary.Shared;
using System.Globalization;
using Microsoft.AspNetCore.Components.Server.ProtectedBrowserStorage;
using Bootstrap;
using WK5.Core.Basis.Filter;
using Toolbelt.Blazor.HotKeys;
using Blazored.FluentValidation;

namespace WK5_Blazor.Pages.Lagerregal
{
    public partial class PositionInhaltComponent
    {
        [Parameter]
        public PackBelegposition? Position { get; set; }

        [Parameter]
        public PackAuftrag? Auftrag { get; set; }

        private string GetSubClass()
        {
            if (Position is null)
            {
                return String.Empty;
            }

            return Position.Bestand < Position.Menge && Position.ARTI_L_LAGERFUEHR ? "not-available" : string.Empty;
        }
        private string GetPosNr()
        {
            if (Position is null)
            {
                return string.Empty;
            }

            if (Position.IstBundle)
            {
                return $"{Position.PosNr}.{Position.PosNr}:";
            }
            else if (Position.BundleParent is not null)
            {
                return $"{Position.BundleParent.PosNr}.{Position.PosNr}:";
            }
            else
            {
                return $"{Position.PosNr}:";
            }
        }
    }
}