using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.AspNetCore.Components;
using WK5.Core.Models.Tools.Lagerregal;

namespace WK5_Blazor.Pages.Lagerregal
{
    public partial class PositionComponent
    {
        [Parameter]
        public PackBelegposition? Position { get; set; }

        [Parameter]
        public PackAuftrag? Auftrag { get; set; }

        
        private string GetHighlightClass()
        {
            if(Position is null)
            {
                return String.Empty;
            }

            List<string> cssClasses = new();
            
            if (Position.BundleParent is not null)
            {
                cssClasses.Add("bundle-pos");
            }

            if (Position.IstGepackt)
            {
                cssClasses.Add("artikel-gepackt");
            }

            return String.Join(" ", cssClasses);
        }

    }
}