﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Models.Tools.Lagerregal;
using WK5.Core.PageModels.Lagerregal;

namespace WK5_Blazor.Pages.Lagerregal
{
    public partial class AuftraegeZuVerpacken : IAsyncDisposable
    {
        public string MeldungZuVerpacken => $"Es sind {(_aufträgeZuPacken.Count > 0 ? _aufträgeZuPacken.Count.ToString() : "keine")} Aufträge zu verpacken";
        public string MeldungZuAbholen => $"Es sind {(_aufträgeZumAbholen.Count > 0 ? _aufträgeZumAbholen.Count.ToString() : "keine")} Aufträge zur Abholung zu verpacken";

        private CancellationTokenSource _cts = new CancellationTokenSource();
        public LagerregalTab ActiveTab { get; set; } = LagerregalTab.ZuPacken;

        private readonly List<PackAuftrag> _aufträgeZuPacken = new();
        private readonly List<AuftragGepackt> _aufträgeGepackt = new();
        private readonly List<PackAuftrag> _aufträgeZumAbholen = new();

        public int AnzahlAufträgeZuPacken { get; set; }
        public int AnzahlAufträgeGepackt { get; set; }
        public int AnzahlAbholaufträgeZuPacken { get; set; }

#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        protected override async Task OnInitializedAsync()
        {
            await LadeAsync(true);
            await SetAlerts();
        }

        private async Task LadeAsync(bool init = false)
        {
            _cts.Cancel();
            _cts = new CancellationTokenSource();
            var token = _cts.Token;
            using FbController2 fbController = new FbController2();
            _aufträgeZuPacken.Clear();
            _aufträgeGepackt.Clear();
            _aufträgeZumAbholen.Clear();
            try
            {
                if (init)
                {
                    AnzahlAbholaufträgeZuPacken = await lagerregalService.GetAnzahlAbholaufträgeZuPackenAsync(fbController, token);
                    AnzahlAufträgeGepackt = await lagerregalService.GetAnzahlAufträgeGepacktAsync(fbController, token);
                }

                switch (ActiveTab)
                {
                    case LagerregalTab.ZuPacken:
                        AnzahlAufträgeZuPacken = await lagerregalService.GetAnzahlAufträgeZuPackenAsync(fbController, token);
                        await foreach (var auftrag in lagerregalService.GetAufträgeZuPackenAsync(fbController, token))
                        {
                            token.ThrowIfCancellationRequested();
                            _aufträgeZuPacken.Add(auftrag);
                            StateHasChanged();
                        }
                        break;
                    case LagerregalTab.BereitsGepackt:
                        AnzahlAufträgeGepackt = await lagerregalService.GetAnzahlAufträgeGepacktAsync(fbController, token);
                        await foreach (var auftrag in lagerregalService.GetAufträgeGepacktAsync(fbController, token))
                        {
                            token.ThrowIfCancellationRequested();
                            _aufträgeGepackt.Add(auftrag);
                            StateHasChanged();
                        }
                        break;
                    case LagerregalTab.ZumAbholen:
                        AnzahlAbholaufträgeZuPacken = await lagerregalService.GetAnzahlAbholaufträgeZuPackenAsync(fbController, token);
                        await foreach (var auftrag in lagerregalService.GetAbholaufträgeZuPackenAsync(fbController, token))
                        {
                            token.ThrowIfCancellationRequested();
                            _aufträgeZumAbholen.Add(auftrag);
                            StateHasChanged();
                        }
                        break;
                    default:
                        break;
                }
            }
            catch (OperationCanceledException) { }

        }

        public string GetNavListClass(bool active) => active ? "nav-link active" : "nav-link";
        public string GetTabClass(bool active) => active ? "tab-pane fade active show" : "tab-pane fade";

        public override ValueTask DisposeAsync()
        {
            _cts?.Cancel();
            _cts?.Dispose();

            return base.DisposeAsync();
        }
    }
}
