﻿using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Server.ProtectedBrowserStorage;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter;
using WK5.Core.Models.Lager;

namespace WK5_Blazor.Pages.Lager.Zugänge
{
    public partial class ZugangÜbersicht : IHasPageFilter
    {
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        private int _seite;
        private readonly List<Zugang> _zugänge = new List<Zugang>();
        private CancellationTokenSource _cts = new CancellationTokenSource();
        public int TotalItems { get; set; }
        [Parameter] public int Seite { get => _seite; set => _seite = value <= 0 ? 1 : value; }
        public ZugangFilter Filter { get; set; } = new ZugangFilter();

        public bool ZeigeRechnungsnummerSpalte => _zugänge.Where(x => !String.IsNullOrWhiteSpace(x.ZUGA_A_RE_NR)).Any();



        public const string LocalStorageFilterKey = "ZugangÜbersicht.Filter";

        protected override async Task OnInitializedAsync()
        {
            await SetAlerts();
        }

        protected override async Task OnParametersSetAsync()
        {
            var localStorageResult = await LocalStorage.GetAsync<ZugangFilter>(LocalStorageFilterKey);
            if (localStorageResult.Success)
            {
                if (localStorageResult.Value is not null)
                {
                    Filter = localStorageResult.Value;
                }
            }

            Filter.Seite = Seite;
            await LadeZugängeAsync();
        }


        private async Task LadeZugängeAsync()
        {
            _cts.Cancel();
            _cts = new CancellationTokenSource();
            _zugänge.Clear();

            await LocalStorage.SetAsync(LocalStorageFilterKey, Filter);

            try
            {
                TotalItems = await lagerService.GetAnzahlZugängeAsnyc(Filter, _cts.Token);
                await foreach (var zugang in lagerService.GetZugängeAsync(Filter, _cts.Token))
                {
                    _zugänge.Add(zugang);
                    StateHasChanged();
                }
            }
            catch (ObjectDisposedException)
            {
                // Tritt auf, wenn die Seite gewechselt wird, aber noch Daten geladen werden
            }
            catch (Exception)
            {
                Filter = new ZugangFilter();
                await LocalStorage.SetAsync(LocalStorageFilterKey, Filter);
                throw;
            }
        }
    }
}
