﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Models;
using WK5.Core.Validators.Lager;

namespace WK5_Blazor.Pages.Lager.Zugänge
{
    public partial class WareEinlagern : IAsyncDisposable
    {
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        private List<WareEinlagernArtikel> _artikel = new List<WareEinlagernArtikel>();
        private bool _lädt;
        private CancellationTokenSource _cts = new CancellationTokenSource();

        private WareEinlagernArtikel? _selectedArtikel;
        private DateTime _datum =  DateTime.Now; //new DateTime(2021, 9, 8); 
        private List<string> _seriennummern = new List<string>();
        private bool _showEtikettenDruckenModal;
        private int _menge;
        private decimal _bezahlterBedarf;
        private bool _scanLagerplatz = true;
        public List<int> OffenerBedarf { get; set; } = new List<int>();
        private WareEinlagernArtikelValidator _validator = new WareEinlagernArtikelValidator();
        protected override async Task OnInitializedAsync()
        {
            await LadeAsync();
        }
        private async Task LadeAsync()
        {
            _cts.Cancel();
            _cts.Dispose();
            _cts = new CancellationTokenSource();
            _artikel.Clear();
            var token = _cts.Token;
            _artikel.Clear();
            _lädt = true;
            using FbController2 fbController = new FbController2();
            await foreach (var item in wareEinlagernService.GetArtikelAsync(_datum, fbController, token))
            {
                _artikel.Add(item);
                StateHasChanged();
            }

            _lädt = false;
        }

        private async Task SaveAsync()
        {
            if(_selectedArtikel is null || !_validator.Validate(_selectedArtikel).IsValid)
            {
                return;
            }

            using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
            await wareEinlagernService.SetLagerplatzAsync(_selectedArtikel, fbController);

            BelegChange newChange = new BelegChange
            {
                BCNG_A_BELEGTYP = "AR",
                BCNG_N_BELEGNR = _selectedArtikel.Artikelnummer,
                BCNG_N_USER = Mitarbeiter.PersonalNummer,
                BCNG_TIMESTAMP = DateTime.Now,
                BCNG_N_ART = 916,
                BCNG_A_WERTALT = $"Menge: {_selectedArtikel.Menge}; Ort: {_selectedArtikel.Lagerplatz}",
                BCNG_A_WERTNEU = $"Eingelagert"
            };

            await BelegChange.InsertBelegChangeAsync(fbController, newChange);



            _artikel.Remove(_selectedArtikel);
            await jsRuntime.ShowToast(ToastType.success, "Ware wurde erfolgreich eingelagert");
        }

        private async Task SelectArtikelAsync(WareEinlagernArtikel artikel)
        {
            _selectedArtikel = artikel;
            using FbController2 fbController = new FbController2();

            _seriennummern = await wareEinlagernService.GetSeriennummernAsync(_datum, artikel.Artikelnummer, fbController).ToListAsync();
            _bezahlterBedarf = await artikelService.GetBedarfBezahlt(artikel.Artikelnummer, Program.AppDaten.Zahlungsbedingungen);
            OffenerBedarf = await artikelService.GetBelegBedarfBezahltAsync(artikel.Artikelnummer, Program.AppDaten.Zahlungsbedingungen).ToListAsync();
        }

        private async Task PrintLabelAsync(string text, int menge)
        {
            if (menge < 1)
            {
                await jsRuntime.ShowToast(ToastType.error, "Es können nicht weniger als 1 Etikett gedruckt werden");
                return;
            }

            for (int i = 0; i < menge; i++)
            {
                await WK5.Core.Drucken.PrintEtikett.Print(text, jsRuntime);
            }
        }

        private string GetBedarfPopOver()
        {
            string bedarf = "<ul>";
            foreach (int nr in OffenerBedarf)
            {
                bedarf += $"<li><a href='/Auftraege/{nr}' target='_blank'>AU-{nr}</a></li>";
            }

            bedarf += "</ul>";

            return bedarf;
        }

        private Task LagerplatzInputFocusInAsync()
        {
            if (_selectedArtikel is not null)
            {
                _selectedArtikel.Lagerplatz = string.Empty;
            }
            return Task.CompletedTask;
        }
        public ValueTask DisposeAsync()
        {
            _cts?.Cancel();
            _cts?.Dispose();
            return ValueTask.CompletedTask;
        }
    }
}
