﻿using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Server.ProtectedBrowserStorage;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter;
using WK5.Core.Drucken.Abgangsliste;
using WK5.Core.Models;
using WK5.Core.Models.Lager;
using WK5.Core.Validators.Lager;

namespace WK5_Blazor.Pages.Lager.Abgänge
{
    public partial class AbgangÜbersicht : IHasPageFilter
    {
        private int _seite;
        private CancellationTokenSource _cts = new CancellationTokenSource();
        private readonly List<Abgang> _abgänge = new List<Abgang>();
        private bool _showPrintAbgangslisteModal;
        private CancellationTokenSource _abganglisteCts = new CancellationTokenSource();
        public int TotalItems { get; set; }
        [Parameter] public int Seite { get => _seite; set => _seite = value <= 0 ? 1 : value; }
        public AbgangFilter Filter { get; set; } = new AbgangFilter();
        public AbgangslisteDruckenInput AbgangslisteDruckenInput { get; set; } = new AbgangslisteDruckenInput();

        private AbgangslisteDruckenValidator _abgangslisteDruckenValidator = new AbgangslisteDruckenValidator();

        public const string LocalStorageFilterKey = "AbgangÜbersicht.Filter";


        protected override async Task OnInitializedAsync()
        {
            await SetAlerts();
        }

        protected override async Task OnParametersSetAsync()
        {
            var localStorageResult = await LocalStorage.GetAsync<AbgangFilter>(LocalStorageFilterKey);
            if (localStorageResult.Success)
            {
                if (localStorageResult.Value is not null)
                {
                    Filter = localStorageResult.Value;
                }
            }

            Filter.Seite = Seite;
            await LadeAbgängeAsync();
        }

        private async Task LadeAbgängeAsync()
        {
            _cts.Cancel();
            _cts = new CancellationTokenSource();
            _abgänge.Clear();

            Filter.Seite = Seite;
            await LocalStorage.SetAsync(LocalStorageFilterKey, Filter);
            try
            {
                TotalItems = await lagerService.GetAnzahlAbgängeAsync(Filter, _cts.Token);
                await foreach (var abgang in lagerService.GetAbgängeAsync(Filter, _cts.Token))
                {
                    _abgänge.Add(abgang);
                    StateHasChanged();
                }
            }
            catch (ObjectDisposedException)
            {
                // Tritt auf, wenn die Seite gewechselt wird, aber noch Daten geladen werden
            }
            catch (Exception)
            {
                Filter = new AbgangFilter();
                await LocalStorage.SetAsync(LocalStorageFilterKey, Filter);
                throw;
            }
        }

        private async Task PrintAbgangslisteAsync()
        {
            _abganglisteCts.Cancel();
            _abganglisteCts = new CancellationTokenSource();
            using FbController2 fbController = new FbController2();

            List<AbgangslisteView> abgänge = await lagerService.GetAbgangslisteViewAsync(AbgangslisteDruckenInput.Von, AbgangslisteDruckenInput.Bis, fbController, _abganglisteCts.Token).ToListAsync();


            PrintAbgangsliste printAbgangsliste = await PrintAbgangsliste.CreateAsync(AbgangslisteDruckenInput.Von, AbgangslisteDruckenInput.Bis, abgänge, Program.AppDaten.Kostenstellen);
            string filename = printAbgangsliste.Print(GlobalConfig.Configuration.OutputPfad);

            var data = await File.ReadAllBytesAsync(filename);

            await downloadService.DownloadFile(Path.GetFileName(filename), data, "application/pdf");
        }
    }
}
