﻿using Microsoft.AspNetCore.Components;
using System;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core.Models.Inventuren;

namespace WK5_Blazor.Pages.Inventur
{
    public partial class UnterlagerÜbersicht
    {
        [Parameter] public int InventurId { get; set; }
        [Parameter] public string Basislager { get; set; } = String.Empty;

        private bool _gesperrt;
        private bool _showAbschließenModal;

        private InventurLagerplatz[] _lagerplätze = Array.Empty<InventurLagerplatz>();
        protected override async Task OnParametersSetAsync()
        {
            _lagerplätze = await inventurService.GetUnterlagerAsync(InventurId, Basislager).ToArrayAsync();
            _gesperrt = await inventurService.IstRegalAbgeschlossenAsync(InventurId, Basislager, Basislager);
        }
        private string GetRegalblockCssClass(InventurLagerplatz lagerplatz)
        {
            if (lagerplatz.IstGesperrt)
            {
                return "lagerplatz-block gesperrt";
            }

            if (lagerplatz.InBearbeitung)
            {
                return "lagerplatz-block in-bearbeitung";
            }

            return "lagerplatz-block";
        }

        private async Task RegalAbschließen()
        {
            await inventurService.RegalAbschließenAsync(InventurId, Basislager, Basislager);
            _gesperrt = true;
        }

        private bool RegalKannAbgeschlossenWerden()
        {

            foreach (var lagerplatz in _lagerplätze)
            {
                if (!lagerplatz.IstGesperrt)
                {
                    return false;
                }
            }

            return true;
        }
    }
}
