﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Models;
using WK5.Core.Models.Inventuren;
using WK5.Core.PageModels.Inventuren;

namespace WK5_Blazor.Pages.Inventur
{
    public partial class NichtZugeordnet
    {
        private List<InventurArtikel> _artikel = new List<InventurArtikel>();
        private bool _showBuchenModal;
        private ValidationContext? validationContext;
        [Parameter] public int InventurId { get; set; }
        private InventurBuchungsAnfrage? _request;
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        private InventurManuellBuchenInput Input { get; set; } = new InventurManuellBuchenInput(new InventurArtikel());
        private bool _showSeriennummerModal;
        private List<Seriennummer> _seriennummern = new List<Seriennummer>();
        private IArtikel? _selectedRegalArtikel;


        private void ShowBuchenModal(InventurArtikel artikel)
        {
            Input = new InventurManuellBuchenInput(artikel);
            validationContext = new ValidationContext(Input);
            _showBuchenModal = true;
        }

        private async Task Buchen()
        {
            if (Input is not null)
            {
                _request = new InventurBuchungsAnfrage(
                    UserId: Mitarbeiter.PersonalNummer,
                    InventurId: InventurId,
                    Regal: Input.Lagerregal,
                    Artikelnummer: Input.Artikel.Artikelnummer,
                    Menge: Input.Menge,
                    Seriennummer: Input.Seriennummer,
                    Kommentar: Input.Kommentar,
                    IgnoreVpe: true
                );

                var response = await inventurService.BuchenAsync(_request);

                if (response.Success)
                {

                    _artikel.Remove(Input.Artikel);
                    await regalFinderService.ChangeLagerplatzAsync(Input.Artikel.Artikelnummer, Input.Lagerregal);
                    await jsRuntime.ShowToast(ToastType.success, response.Message ?? String.Empty);
                }
                else
                {
                    if (response.Status == InventurBuchungStatus.SeriennummerBenötigt)
                    {
                        _showSeriennummerModal = true;
                        _seriennummern = response.Value as List<Seriennummer> ?? new List<Seriennummer>();
                    }
                    else
                    {
                        await jsRuntime.ShowToast(ToastType.error, response.Message ?? String.Empty);
                    }
                }

            }
        }



        protected override async Task OnParametersSetAsync()
        {
            _artikel = await inventurService.GetArtikelNichtZugeordnetAsync(InventurId).ToListAsync();
        }
    }
}
