﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Authorization;
using System;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Models;
using WK5_Blazor.Authorization;

namespace WK5_Blazor.Pages.Inventur
{
    public partial class HauptlagerÜbersicht
    {
        [Parameter] public int InventurId { get; set; }
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        private Hauptlager[] _hauptlager = Array.Empty<Hauptlager>();

        public bool _inventurWirdAbgeschlossen;
        public string AbschlussStatus { get; set; } = "Inventur Abschließen";
        private async Task InventurAbschließenAsync()
        {
            _inventurWirdAbgeschlossen = true;
            AbschlussStatus = "Generiere Zähllisten...";
            // Die Reihenfolge spielt hier eine wichtige Rolle, da der Bestand der Artikel im letzten Schritt verändert wird, daher müssen alle listen im voraus generiert werden
            await inventurService.GeneriereZähllistenAsync(InventurId).ToListAsync();
            AbschlussStatus = "Generiere Erfassungsliste...";
            await InvokeAsync(StateHasChanged);
            await inventurService.GeneriereErfassungslisteAsync(InventurId);
            AbschlussStatus = "Aktualisiere Bestand...";
            await InvokeAsync(StateHasChanged);
            await inventurService.InventurAbschließenAsync(InventurId, Mitarbeiter.PersonalNummer);
            await AddAlertAsync(new AlertBox
            {
                AlertType = AlertType.Success,
                Message = "Inventur erfolgreich abgeschlossen"
            });


            navigationManager.NavigateTo("/");
        }

        protected override async Task OnParametersSetAsync()
        {
            _hauptlager = await inventurService.GetHauptlagerAsync(InventurId).ToArrayAsync();
        }

        private string GetRegalblockCssClass(Hauptlager lagerplatz)
        {
            if (lagerplatz.IstGesperrt)
            {
                return "lagerplatz-block gesperrt";
            }

            if (lagerplatz.InBearbeitung)
            {
                return "lagerplatz-block in-bearbeitung";
            }

            return "lagerplatz-block";
        }

        public bool ScannenAbgeschlossen
        {
            get
            {
                foreach (var lagerplatz in _hauptlager)
                {
                    if (!lagerplatz.IstGesperrt)
                    {
                        return false;
                    }
                }
                return true;
            }
        }

        private bool InventurKannAbgeschlossenWerden()
        {
            if (!Mitarbeiter.IsAdmin || !ScannenAbgeschlossen)
            {
                return false;
            }

            return true;
        }
    }
}
