﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Models;
using WK5.Core.Models.Inventuren;
using WK5.Core.PageModels.Inventuren;

namespace WK5_Blazor.Pages.Inventur
{
    public partial class Fehlbestände
    {
        [Parameter] public int InventurId { get; set; }

        private List<InventurArtikelGebucht> _artikel = new List<InventurArtikelGebucht>();
        private ValidationContext? validationContext;
        private InventurBuchungsAnfrage? _request;
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        private InventurKorrekturBuchungInput Input { get; set; } = new InventurKorrekturBuchungInput(new InventurArtikelGebucht());
        private bool _showBuchenModal;
        private bool _showSeriennummerModal;
        private List<Seriennummer> _seriennummern = new List<Seriennummer>();
        private IArtikel? _selectedRegalArtikel;
        protected override async Task OnParametersSetAsync()
        {
            _artikel = await inventurService.GetGebuchteArtikelByInventurAsync(InventurId).Where(x => x.TotalGebucht < x.Bestand || x.TotalGebucht > x.Bestand).ToListAsync();
        }

        private void ShowBuchenModal(InventurArtikelGebucht artikel)
        {
            Input = new InventurKorrekturBuchungInput(artikel);
            validationContext = new ValidationContext(Input);
            _showBuchenModal = true;
        }
        private async Task Buchen()
        {
            if (Input is not null)
            {
                _request = new InventurBuchungsAnfrage(Mitarbeiter.PersonalNummer, InventurId, "KORREKTUR", Input.Artikel.Artikelnummer, Input.Menge, Input.Seriennummer, Input.Kommentar, true);
                var response = await inventurService.BuchenAsync(_request);

                if (response.Success)
                {
                    if (Input.Artikel.TotalGebucht + Input.Menge == Input.Artikel.Bestand)
                    {
                        _artikel.Remove(Input.Artikel);
                    }
                    else
                    {
                        Input.Artikel.TotalGebucht += Input.Menge;
                    }
                    await jsRuntime.ShowToast(ToastType.success, response.Message ?? String.Empty);
                }
                else
                {
                    if (response.Status == InventurBuchungStatus.SeriennummerBenötigt)
                    {
                        _showSeriennummerModal = true;
                        _seriennummern = response.Value as List<Seriennummer> ?? new List<Seriennummer>();
                    }
                    else
                    {
                        await jsRuntime.ShowToast(ToastType.error, response.Message ?? String.Empty);
                    }
                }
            }
        }
    }
}
