﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Toolbelt.Blazor.HotKeys;

namespace WK5_Blazor
{
    public class HotKeyPageBase : ComponentBase, IAsyncDisposable
    {
#nullable disable
        [Inject] public HotKeys HotKeys { get; set; }
#nullable enable
        public HotKeysContext? HotKeysContext { get; private set; }

        protected override Task OnInitializedAsync()
        {
            this.HotKeysContext = this.HotKeys.CreateContext();
            if (this.HotKeysContext is not null)
                AddHotKeys(this.HotKeysContext);
            return base.OnInitializedAsync();
        }

        public virtual void AddHotKeys(HotKeysContext context)
        {
            return;
        }

        public string GetHelpMarkup()
        {
            if (this.HotKeysContext is not null)
            {
                string template = "<ul>";
                foreach (var key in this.HotKeysContext.Keys)
                {
                    template += key.ToString();
                }
                template += "</ul>";
                return template;
            }
            else
            {
                return String.Empty;
            }
        }

        public virtual ValueTask DisposeAsync()
        {
            this.HotKeysContext?.Dispose();
            return ValueTask.CompletedTask;
        }
    }
}
