using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.RazorPages;
using WK5.Core;
using WK5.Core.Drucken;
using WK5.Core.Drucken.Angebote;
using WK5.Core.Drucken.Auftrge;
using WK5.Core.Drucken.Bestellungen;
using WK5.Core.Drucken.Gutschriften;
using WK5.Core.Drucken.Lieferscheine;
using WK5.Core.Drucken.Rechnungen;
using WK5.Core.Models;

namespace WK5_Blazor.Pages.Bestellungen
{
    public class VorschauModel : PageModel
    {
        public async Task<IActionResult> OnGetAsync(int bestellnummer, int mitarbeiterId)
        {
            using FbController2 fbController = new FbController2();


            var bestellung = await Bestellung.GetBestellungAsync(bestellnummer, fbController);
            var mitarbeiter = await Personal.GetPersonalAsync(mitarbeiterId);
            if (bestellung is not null)
            {
                PrintBestellung printer = await PrintBestellung.CreateAsync(fbController, bestellung, mitarbeiter?.GetName() ?? string.Empty);
                string filename = printer.Print(GlobalConfig.Configuration.OutputPfad);
                return File(await System.IO.File.ReadAllBytesAsync(filename), "application/pdf");
            }

            return Page();
        }
    }
}
