﻿using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Web.Virtualization;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Basis.Filter;
using WK5.Core.Drucken.ProvisionsAbrechnung;
using WK5.Core.Models;
using WK5.Core.PageModels.Admin.Mitarbeiterverwaltung;
using WK5.Core.Validators.Admin.Mitarbeiterverwaltung;

namespace WK5_Blazor.Pages.Admin.Mitarbeiterverwaltung
{
    public partial class MitarbeiterÜbersicht
    {
        public Personal? MitarbeiterEdit { get; set; }
        public EditMode Modus { get; set; } = EditMode.Anlage;

        private PersonalValidator _personalValidator = new PersonalValidator();
        public PersonalFilter FilterPersonal { get; set; } = new PersonalFilter();

        

        public Vertreter? VertreterEdit { get; set; }

        private ProvisionsabrechnungInput _provisionInput = new ProvisionsabrechnungInput();
        private bool _isDownloadingProvision = false;
        private bool _showProvisionAbrechnenModal;

#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable

        private async Task ProvisionenAuswertenAsync()
        {
            _isDownloadingProvision = true;
            Vertreter? vertreter = Program.AppDaten.MitarbeiterVertreter.FirstOrDefault(x => x.VERT_N_NR == _provisionInput.VertreterId);

            if (vertreter is not null)
            {
                using FbController2 fbController = new FbController2();
                List<Provision> provisionen = _provisionInput.AufBasisVonRoherlös
                    ? await vertreterService.GetProvisionsAbrechnungAufBasisVonRoherlösAsync(_provisionInput.Von, _provisionInput.Bis, _provisionInput.VertreterId, fbController).ToListAsync()
                    : await vertreterService.GetProvisionsabrechnungAsync(_provisionInput.Von, _provisionInput.Bis, _provisionInput.VertreterId, fbController).ToListAsync();

                if (provisionen.Count > 0)
                {
                    PrintProvisionsAbrechnung abrechnung = await PrintProvisionsAbrechnung.CreateAsync(provisionen, vertreter, new Zeitraum { Von = _provisionInput.Von, Bis = _provisionInput.Bis });
                    string pfad = abrechnung.Print(GlobalConfig.Configuration.OutputPfad);
                    await downloadService.DownloadFile(Path.GetFileName(pfad), await File.ReadAllBytesAsync(pfad), "application/pdf");
                    await downloadService.ClearBuffers();
                }
                else
                {
                    await jsRuntime.ShowToast(ToastType.error, $"Für den Vertreter {vertreter.GetName()} gibt es keine Provisionen innerhalb des Zeitraumes vom {_provisionInput.Von.ToShortDateString()} bis zum {_provisionInput.Bis.ToShortDateString()}");
                }
            }

            _isDownloadingProvision = false;

        }
        private Task NewMitarbeiterAsync()
        {
            Modus = EditMode.Anlage;
            MitarbeiterEdit = new Personal();
            VertreterEdit = new Vertreter();
            return Task.CompletedTask;
        }

        private string GetRowClass(Personal personal)
        {
            if (FilterPersonal.NurAktive && personal.PERS_L_INAKTIV)
            {
                return "d-none";
            }

            if (!String.IsNullOrWhiteSpace(FilterPersonal.Suchbegriff) && !personal.GetName().Contains(FilterPersonal.Suchbegriff, StringComparison.OrdinalIgnoreCase))
            {
                return "d-none";
            }

            return string.Empty;
        }



        private Task EditMitarbeiterAsync(Personal personal)
        {
            Modus = EditMode.Bearbeiten;
            MitarbeiterEdit = (Personal)personal.Clone();

            var sucheVertreter = Program.AppDaten.MitarbeiterVertreter.FirstOrDefault(x => x.VERT_N_NR == MitarbeiterEdit.PERS_N_NR);

            VertreterEdit = new Vertreter
            {
                VERT_N_NR = MitarbeiterEdit.PERS_N_NR,
                VERT_A_NAME = MitarbeiterEdit.PERS_A_NAME,
                VERT_A_VORNAME = MitarbeiterEdit.PERS_A_VORNAME,
                VERT_N_PERSONALNR = MitarbeiterEdit.PERS_N_NR,
                VERT_N_PROVISION = sucheVertreter?.VERT_N_PROVISION ?? 0
            };


            return Task.CompletedTask;
        }
        private async Task SaveChangesAsync()
        {
            if (MitarbeiterEdit is null)
            {
                return;
            }

            using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
            if (Modus is EditMode.Anlage)
            {
                await mitarbeiterService.CreateAsync(MitarbeiterEdit, fbController);
                Program.AppDaten.Mitarbeiter.Add(MitarbeiterEdit);

                if (MitarbeiterEdit.PERS_L_VERTRETER && VertreterEdit is not null)
                {
                    VertreterEdit.VERT_N_NR = MitarbeiterEdit.PERS_N_NR;
                    VertreterEdit.VERT_N_PERSONALNR = MitarbeiterEdit.PERS_N_NR;
                    await vertreterService.CreateAsync(VertreterEdit, fbController);
                    Program.AppDaten.MitarbeiterVertreter.Add(VertreterEdit);
                }

                await jsRuntime.ShowToast(ToastType.success, "Mitarbeiter wurde erfolgreich angelegt");
            }
            else
            {
                await mitarbeiterService.UpdateAsync(MitarbeiterEdit, fbController);
                Personal? mitarbeiter = Program.AppDaten.Mitarbeiter.Where(x => x.PERS_N_NR == MitarbeiterEdit.PERS_N_NR).FirstOrDefault();

                if (mitarbeiter is not null)
                {
                    mitarbeiter.PERS_A_VORNAME = MitarbeiterEdit.PERS_A_VORNAME;
                    mitarbeiter.PERS_A_NAME = MitarbeiterEdit.PERS_A_NAME;
                    mitarbeiter.PERS_L_VERTRETER = MitarbeiterEdit.PERS_L_VERTRETER;
                    mitarbeiter.PERS_L_INAKTIV = MitarbeiterEdit.PERS_L_INAKTIV;
                }

                if (VertreterEdit is not null)
                {
                    var sucheVertreter = Program.AppDaten.MitarbeiterVertreter.FirstOrDefault(x => x.VERT_N_NR == MitarbeiterEdit.PERS_N_NR);

                    if (sucheVertreter is null)
                    {
                        if (MitarbeiterEdit.PERS_L_VERTRETER)
                        {
                            await vertreterService.CreateAsync(VertreterEdit, fbController);
                        }
                    }
                    else
                    {
                        VertreterEdit.VERT_L_INAKTIV = !MitarbeiterEdit.PERS_L_VERTRETER;
                        await vertreterService.UpdateAsync(VertreterEdit, fbController);
                        sucheVertreter.VERT_A_NAME = VertreterEdit.VERT_A_NAME;
                        sucheVertreter.VERT_A_VORNAME = VertreterEdit.VERT_A_VORNAME;
                        sucheVertreter.VERT_N_PROVISION = VertreterEdit.VERT_N_PROVISION;
                        sucheVertreter.VERT_N_PERSONALNR = VertreterEdit.VERT_N_PERSONALNR;
                        sucheVertreter.VERT_L_INAKTIV = VertreterEdit.VERT_L_INAKTIV;

                    }


                }

                MitarbeiterEdit = null;

                await jsRuntime.ShowToast(ToastType.success, "Mitarbeiter wurde erfolgreich aktualisiert.");


            }
        }
    }
}
