﻿using KarleyLibrary.Erweiterungen;
using Microsoft.AspNetCore.Components.Forms;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Models;

namespace WK5_Blazor.Pages.Admin.Hilfsdaten
{
    public partial class ArtikeltypenÜbersicht
    {
        private EditForm? _form;
        private bool _showDeleteModal;
        private bool _showOptionModal;
        private List<int> _blockedOptionIds = new List<int>();
        public Artikeltyp? SelectedItem { get; set; }

        public EditMode Modus { get; set; } = EditMode.Anlage;

        private Task AddAsync()
        {
            SelectedItem = new();
            Modus = EditMode.Anlage;
            return Task.CompletedTask;
        }

        private Task EditAsync(Artikeltyp text)
        {
            SelectedItem = (Artikeltyp)text.Clone();
            Modus = EditMode.Bearbeiten;
            return Task.CompletedTask;
        }

        private async Task DeleteAsync()
        {
            if (SelectedItem is null)
            {
                return;
            }

            if (SelectedItem.Id > 0)
            {

                using FbController2 fbController = new FbController2();
                await artikeltypService.DeleteAsync(SelectedItem, fbController);

                Program.AppDaten.Artikeltypen = await artikeltypService.GetAsync(fbController).ToListAsync();

            }

            await jsRuntime.ShowToast(ToastType.success, "Artikeltyp wurde erfolgreich gelöscht");

            SelectedItem = null;
        }

        private async Task SaveAsync()
        {
            if (SelectedItem is null || _form is null || _form.EditContext is null)
            {
                return;
            }

            if (_form.EditContext.Validate())
            {
                using FbController2 fbController = new FbController2();
                if (Modus is EditMode.Anlage)
                {
                    await artikeltypService.CreateAsync(SelectedItem, fbController);
                    Program.AppDaten.Artikeltypen = await artikeltypService.GetAsync(fbController).ToListAsync();
                    Program.AppDaten.ArtikelOptionen = await artikelOptionenService.GetAsync(fbController).ToListAsync();
                    await jsRuntime.ShowToast(ToastType.success, "Artikeltyp wurde erfolgreich angelegt");
                }
                else
                {
                    await artikeltypService.UpdateAsync(SelectedItem, fbController);

                    Program.AppDaten.Artikeltypen = await artikeltypService.GetAsync(fbController).ToListAsync();
                    Program.AppDaten.ArtikelOptionen = await artikelOptionenService.GetAsync(fbController).ToListAsync();

                    await jsRuntime.ShowToast(ToastType.success, "Artikeltyp wurde erfolgreich aktualisiert");

                }

                
                SelectedItem = null;
            }
        }

        private Task ShowOptionModalAsync()
        {
            if (SelectedItem is not null)
            {
                _showOptionModal = true;
                _blockedOptionIds = SelectedItem.Optionen.Select(x => x.Id).ToList();
            }

            return Task.CompletedTask;
        }
        private Task OptionSelectedAsync(ArtikelOption option)
        {
            if (SelectedItem is not null)
            {
                SelectedItem.Optionen.Add(option);
                _showOptionModal = false;
                _blockedOptionIds.Clear();
            }
            return Task.CompletedTask;
        }
    }
}
