﻿using KarleyLibrary.Erweiterungen;
using Microsoft.AspNetCore.Components.Forms;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Models;

namespace WK5_Blazor.Pages.Admin.Hilfsdaten
{
    public partial class ArtikelOptionenÜbersicht
    {
        private EditForm? _form;
        private bool _showDeleteModal;
        public ArtikelOption? SelectedItem { get; set; }

        public EditMode Modus { get; set; } = EditMode.Anlage;

        private Task AddAsync()
        {
            SelectedItem = new();
            Modus = EditMode.Anlage;
            return Task.CompletedTask;
        }

        private Task EditAsync(ArtikelOption text)
        {
            SelectedItem = text.DeepCopy();
            Modus = EditMode.Bearbeiten;
            return Task.CompletedTask;
        }

        private async Task DeleteAsync()
        {
            if (SelectedItem is null)
            {
                return;
            }

            if (SelectedItem.Id > 0)
            {
                using FbController2 fbController = new FbController2();
                await artikelOptionenService.DeleteAsync(SelectedItem, fbController);
                Program.AppDaten.ArtikelOptionen = await artikelOptionenService.GetAsync(fbController).ToListAsync();
                Program.AppDaten.Artikeltypen = await artikeltypService.GetAsync(fbController).ToListAsync();
            }

            await jsRuntime.ShowToast(ToastType.success, "Artikeloption wurde erfolgreich gelöscht");

            SelectedItem = null;
        }

        private async Task SaveAsync()
        {
            if (SelectedItem is null || _form is null || _form.EditContext is null)
            {
                return;
            }

            if (_form.EditContext.Validate())
            {
                using FbController2 fbController = new FbController2();
                if (Modus is EditMode.Anlage)
                {
                    await artikelOptionenService.CreateAsync(SelectedItem, fbController);
                    Program.AppDaten.ArtikelOptionen = await artikelOptionenService.GetAsync(fbController).ToListAsync();
                    Program.AppDaten.Artikeltypen = await artikeltypService.GetAsync(fbController).ToListAsync();
                    await jsRuntime.ShowToast(ToastType.success, "Artikeloption wurde erfolgreich angelegt");
                }
                else
                {
                    await artikelOptionenService.UpdateAsync(SelectedItem, fbController);
                    Program.AppDaten.ArtikelOptionen = await artikelOptionenService.GetAsync(fbController).ToListAsync();
                    Program.AppDaten.Artikeltypen = await artikeltypService.GetAsync(fbController).ToListAsync();
                    await jsRuntime.ShowToast(ToastType.success, "Artikeloption wurde erfolgreich aktualisiert");

                }


                SelectedItem = null;
            }
        }
        private Task AddOptionValueAsync()
        {
            if (SelectedItem is not null)
            {
                SelectedItem.OptionValues.Add(new ArtikelOptionValue());
            }
            return Task.CompletedTask;
        }
        private Task RemoveOptionValueAsync(ArtikelOptionValue optionValue)
        {
            if(SelectedItem is not null)
            {
                SelectedItem.OptionValues.Remove(optionValue);
            }
            return Task.CompletedTask;
        }
    }
}
