﻿using Microsoft.AspNetCore.Components;
using Microsoft.JSInterop;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace WK5_Blazor.Pages
{
    /// <summary>
    /// Stellt die Basis einer Blazor Page dar, die nur von einem <see cref="WK5.Core.AppMitarbeiter"/> gleichzeitig aufgerufen werden kann.
    /// </summary>
    public abstract class ActivePageBase : AlertPageBase, IActivePage
    {
        public ActivePage? Page { get; set; }
        /// <summary>
        /// Ruft einen Wert ab, der angibt, ob die Seite bereits durch einen anderen Mitarbeiter gesperrt ist, oder nicht.
        /// </summary>
        public bool SperreDurchAnderenUser { get; set; }
        protected bool _isDisposed;

        private DotNetObjectReference<ActivePageBase> _reference;
        private IJSObjectReference? jsModule;
#nullable disable
        [Inject] public IJSRuntime jsRuntime { get; set; }
#nullable enable
        public ActivePageBase()
        {
            _reference = DotNetObjectReference.Create(this);
        }

        protected override async Task OnInitializedAsync()
        {
            await LoadJavascriptEvent();
            await base.OnInitializedAsync();
        }

        public abstract Task CheckActivePageAsync();        

        [JSInvokable]
        public void OnBeforePageUnload()
        {
            ActivePages.RemoveActivePage(Page);
        }

        public async Task LoadJavascriptEvent()
        {
            jsModule = await jsRuntime.InvokeAsync<IJSObjectReference>("import", "./js/activepage.js");

            if(jsModule is not null)
            {
                await jsModule.InvokeVoidAsync("init", _reference);
            }
        }

        public override async ValueTask DisposeAsync()
        {
            if(jsModule is not null)
            {
                await jsModule.DisposeAsync();
            }

            ActivePages.RemoveActivePage(Page);
            _isDisposed = true;

            // Basis muss aufgerufen werden, damit das Dispose der AlertPageBase aufgerufen wird.
            await base.DisposeAsync();
        }
    }
}
