﻿using WK5.Core.Models;
using WK5.Core.PageModels.Stammdaten.Kunden;

namespace WK5_Blazor.CoreExtensions
{
    public static class RechnungsanschriftExtensions
    {
        public static RechnungsanschriftInput ToInput(this Rechnungsanschrift anschrift)
        {
            return new RechnungsanschriftInput(anschrift.KURE_N_NR, anschrift.WirdVerwendet)
            {
                Email = anschrift.KURE_A_EMAIL,
                Fax = anschrift.KURE_A_FAX,
                Firma = anschrift.KURE_A_NAME1,
                Land = anschrift.KURE_A_LAND,
                Name2 = anschrift.KURE_A_NAME2,
                Name3 = anschrift.KURE_A_NAME3,
                Postleitzahl = anschrift.KURE_A_PLZ,  // Postleitzahl vor Ort, weil das Input diese automatisch versucht zu ergänzen
                Ort = anschrift.KURE_A_ORT,
                Straße = anschrift.KURE_A_STRASSE,
                Telefon = anschrift.KURE_A_TEL,
                Kundennummer = anschrift.KURE_A_KUNDNR,
                Partner = anschrift.KURE_A_PARTNER,
                Hauptanschrift = anschrift.KURE_WK5_L_HAUPTANSCHRIFT,
                Notiz = anschrift.KURE_WK5_A_NOTIZ
            };
        }
    }
}
