﻿using WK5.Core.Models;
using WK5.Core.PageModels.Stammdaten.Lieferanten;

namespace WK5_Blazor.CoreExtensions
{
    /// <summary>
    /// Stellt eine Erweiterungsklasse für den Interop der LieferantenPartner zwischen WK5.Core und WK5.Blazor dar
    /// </summary>
    public static class LieferantenPartnerExtensions
    {
        /// <summary>
        /// Konvertiert ein LieferantenPartner zu einem LieferantenPartnerInput
        /// </summary>
        /// <param name="partner">Der zu konvertierende LieferantenPartner</param>
        /// <returns>Gibt einen <see cref="LieferantenPartnerInput"/> zurück</returns>
        public static LieferantenPartnerInput ToInput(this LieferantenPartner partner)
        {
            return new LieferantenPartnerInput(partner.LIEP_N_NR)
            {
                Adresstext = partner.LIEP_A_ADRESSTEXT,
                Anrede = partner.LIEP_A_ANREDE,
                Bereich = partner.LIEP_A_BEREICH,
                Email = partner.LIEP_A_EMAIL,
                Fax = partner.LIEP_A_TELEFAX,
                Handy = partner.LIEP_A_HANDY,
                Hauptansprechpartner = partner.LIEP_L_HAUPTPARTNER,
                Lieferantennummer = partner.LIEP_N_LIEFNR,
                Name = partner.LIEP_A_NAME,
                Notiz = partner.LIEP_A_NOTIZ,
                Telefon = partner.LIEP_A_TELEFON
            };
        }
    }
}
