﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core.Models;
using WK5.Core.PageModels.Stammdaten.Lieferanten;

namespace WK5_Blazor.CoreExtensions
{
    /// <summary>
    /// Stellt Erweiterungsmethoden für den Interop zwischen WK5.Core und WK5.Blazor dar
    /// </summary>
    public static class LieferantenExtensions
    {
        /// <summary>
        /// Konvertiert ein Lieferantenobjekt in einen LieferantenInputobjekt
        /// </summary>
        /// <param name="lieferant">Das Objekt des zu konvertierenden Lieferants</param>
        /// <returns>Gibt einen <see cref="Task"/> of <see cref="LieferantenInput"/> zurück</returns>
        public static async Task<LieferantenInput> ToInputAsync(this Lieferant lieferant)
        {
            var input = new LieferantenInput(lieferant.LIEF_N_NR);

            input.Name1 = lieferant.LIEF_A_NAME1 ?? String.Empty;
            input.Name2 = lieferant.LIEF_A_NAME2 ?? String.Empty;
            input.Suchbegriff = lieferant.LIEF_A_SUCHCODE ?? String.Empty;
            input.Strasse = lieferant.LIEF_A_STR ?? String.Empty;
            input.Land = lieferant.LIEF_A_LAND ?? String.Empty;
            input.Postleitzahl = lieferant.LIEF_A_PLZ ?? String.Empty;
            input.Ort = lieferant.LIEF_A_ORT ?? String.Empty;
            input.Telefon1 = lieferant.LIEF_A_TEL1 ?? String.Empty;
            input.Telefon2 = lieferant.LIEF_A_TEL2 ?? String.Empty;
            input.Fax = lieferant.LIEF_A_FAX ?? String.Empty;
            input.Email = lieferant.LIEF_A_EMAIL ?? String.Empty;
            input.Homepage = lieferant.LIEF_A_URL ?? String.Empty;
            input.UnsereKundennummer = lieferant.LIEF_A_KUNDENNR ?? String.Empty;
            input.Notiz = StringErweiterung.RtfToString(lieferant.LIEF_A_NOTIZ);
            input.AbweichendeRuecklieferadresse = lieferant.LIEF_L_LIEFABWEICHEND;
            input.Gesperrt = lieferant.LIEF_L_SPERRE;
            input.RueckgaberechtTage = lieferant.LIEF_N_RUECKGABE_TAGE;
            input.Rueckgaberecht = lieferant.LIEF_L_RUECKGABE;
            input.MwStId = lieferant.LIEF_N_MWSTKENNUNG;
            input.Bankkonto = lieferant.LIEF_A_KONTO ?? String.Empty;
            input.Bankleitzahl = lieferant.LIEF_A_BLZ ?? String.Empty;
            input.Bankname = lieferant.LIEF_A_BANKNAME ?? String.Empty;
            input.Bescheinigung13bUSTG = lieferant.LIEF_L_PARGR13B;
            input.Bescheinigung13bUSTGGueltigBis = lieferant.LIEF_D_PARGR13B;
            input.Bescheinigung48bESTG = lieferant.LIEF_L_PARGR48B;
            input.Bescheinigung48bESTGGueltigBis = lieferant.LIEF_D_PARGR48B;
            input.BIC = lieferant.LIEF_A_BIC ?? String.Empty;
            input.Drittland = lieferant.LIEF_L_AUSLAND;
            input.EULieferant = lieferant.LIEF_L_EUKUNDE;
            input.FrachtfreiAb = lieferant.LIEF_N_FRACHTFR_AB;
            input.IBAN = lieferant.LIEF_A_IBAN ?? String.Empty;
            input.Kontoinhaber = lieferant.LIEF_A_KONTOINHABER ?? String.Empty;
            input.Kreditorennummer = lieferant.LIEF_A_KREDITORNR ?? String.Empty;
            input.Lieferantengruppe = lieferant.LIEF_N_GRUPPE;
            input.LieferbedingungId = lieferant.LIEF_N_LIBD;
            input.Mindestbestellwert = lieferant.LIEF_N_MIDBESTWERT;
            input.Mindestlohnbescheinigung = lieferant.LIEF_L_MINDESTLOHN;
            input.Rabatt = lieferant.LIEF_N_RABATT;
            input.Umsatzsteuer = lieferant.LIEF_L_MWST;
            input.UstId = lieferant.LIEF_A_USTIDNR ?? String.Empty;
            input.Waehrung = lieferant.LIEF_A_WAEHRUNG ?? String.Empty;
            input.ZahlungsbedingungId = lieferant.LIEF_N_ZABD;
            input.Selektionsmerkmal1 = lieferant.LIEF_A_SELEKTION1 ?? String.Empty;
            input.Selektionsmerkmal2 = lieferant.LIEF_A_SELEKTION2 ?? String.Empty;
            input.Selektionsmerkmal3 = lieferant.LIEF_A_SELEKTION3 ?? String.Empty;
            input.Bonus = lieferant.LIEF_L_BONUS;
            input.Bonus1Prozent = lieferant.LIEF_N_BONUS1PROZ;
            input.Bonus1Wert = lieferant.LIEF_N_BONUS1WERT;
            input.Bonus2Prozent = lieferant.LIEF_N_BONUS2PROZ;
            input.Bonus2Wert = lieferant.LIEF_N_BONUS2WERT;
            input.Bonus3Prozent = lieferant.LIEF_N_BONUS3PROZ;
            input.Bonus3Wert = lieferant.LIEF_N_BONUS3WERT;
            input.RuecklieferAdressId = lieferant.LIEF_WK5_N_RUECK_ADRESSE;
            input.DirektLieferungErlaubt = lieferant.LIEF_WK5_L_DIREKT_ERLAUBT;
            input.Verpackungskosten = lieferant.LIEF_WK5_N_VERPACKKOSTEN;
            input.Versicherungskosten = lieferant.LIEF_WK5_N_VERSICHERKOSTEN;
            input.Versandkosten = lieferant.LIEF_WK5_N_VERSANDKOSTEN;
            input.ShopPasswort = lieferant.LIEF_WK5_B_SHOPPASSWORT;
            input.ShopUsername = lieferant.LIEF_WK5_B_SHOPUSERNAME;
            input.Autoimport = lieferant.LIEF_WK5_L_AUTOIMPORT;
            input.Mindermengenzuschlag = lieferant.Mindermengenzuschlag;
            input.Partner = lieferant.LIEF_A_PARTNER;
            input.Warnhinweise = lieferant.LIEF_A_WARNHINWEISE;
            input.Eigenlieferant = lieferant.LIEF_L_EIGENLIEFERANT;

            List<Task> tasks = new List<Task>();

            tasks.Add(Task.Run(async () =>
            {
                var ansprechpartner = await LieferantenPartner.GetLieferantenPartnerAsync(lieferant.LIEF_N_NR).ToListAsync();
                foreach (var partner in ansprechpartner)
                {
                    input.Ansprechpartner.Add(partner.ToInput());
                }
            }));

            tasks.Add(Task.Run(async () =>
            {
                var rechnunganschriften = await LieferantenAnschrift.GetAnschriftenAsync(lieferant.LIEF_N_NR).ToListAsync();
                foreach (var anschrift in rechnunganschriften)
                {
                    input.Anschriften.Add(anschrift.ToInput());
                }
            }));


            await Task.WhenAll(tasks);

            return input;
        }
    }
}
