using System.Threading.Tasks;
using WK5.Core.Models;
using WK5.Core.PageModels.Stammdaten.Artikeldaten;

namespace WK5_Blazor.CoreExtensions
{
    public static class LieferantenArtikelExtension
    {
        public static async Task<LieferantenArtikelInput> ToInputAsync(this Lieferantenartikel artikel)
        {
            var input = new LieferantenArtikelInput(artikel.ARLI_A_ARTIKELNR)
            {
                Preis = artikel.ARLI_N_PREIS,
                Beschreibung1 = artikel.ARLI_A_BEZ1,
                Beschreibung2 = artikel.ARLI_A_BEZ2,
                Beschreibung3 = artikel.ARLI_A_BEZ3,
                Beschreibung4 = artikel.ARLI_A_BEZ4,
                Beschreibung5 = artikel.ARLI_A_BEZ5,
                Bestellnummer = artikel.ARLI_A_BESTELLNR,
                Hauptlieferant = artikel.ARLI_L_HAUPTLIEFERANT,
                Kurs = artikel.ARLI_N_KURS,
                LetzteÄnderung = artikel.ARLI_D_LETZAEND,
                Mindestabnahme = artikel.ARLI_N_MINDESTABNAHME,
                Lieferantennummer = artikel.ARLI_N_LIEFNR,
                Notiz = artikel.ARLI_B_NOTIZ,
                PreisWährung = artikel.ARLI_N_WAEHRUNGSPREIS,
                Rabatt = artikel.ARLI_N_RABATT,
                Rabatt2 = artikel.ARLI_N_RABATT2,
                Sonstiges = artikel.ARLI_N_SONSTKOST,
                Staffelmenge1 = artikel.ARLI_N_MENGE1,
                Staffelmenge2 = artikel.ARLI_N_MENGE2,
                Staffelmenge3 = artikel.ARLI_N_MENGE3,
                Staffelmenge4 = artikel.ARLI_N_MENGE4,
                StaffelPreis1 = artikel.ARLI_N_PREISMENGE1,
                StaffelPreis2 = artikel.ARLI_N_PREISMENGE2,
                StaffelPreis3 = artikel.ARLI_N_PREISMENGE3,
                StaffelPreis4 = artikel.ARLI_N_PREISMENGE4,
                StaffelRabatt1 = artikel.ARLI_N_RABATTMENGE1,
                StaffelRabatt2 = artikel.ARLI_N_RABATTMENGE2,
                StaffelRabatt3 = artikel.ARLI_N_RABATTMENGE3,
                StaffelRabatt4 = artikel.ARLI_N_RABATTMENGE4,
                Lieferantenbestand = artikel.WK5_ARLI_N_LIEFBESTAND,
                Währung = artikel.ARLI_A_WAEHRUNG,
                Teuerung = artikel.ARLI_N_TEUERUNG,
                Verpackungskosten = artikel.ARLI_N_VERPACKKOST,
                Versandkosten = artikel.ARLI_N_VERSANDKOST
            };

            Lieferant? lieferant = await Lieferant.GetLieferantAsync(artikel.ARLI_N_LIEFNR);
            input.Lieferant = lieferant;

            StaffelpreisCollection staffelCollection = new StaffelpreisCollection(4);
            staffelCollection.SetBezugspreis(artikel.ARLI_N_PREIS);
            staffelCollection.Add(artikel.ARLI_N_MENGE1, artikel.ARLI_N_PREISMENGE1, artikel.ARLI_N_RABATTMENGE1);
            staffelCollection.Add(artikel.ARLI_N_MENGE2, artikel.ARLI_N_PREISMENGE2, artikel.ARLI_N_RABATTMENGE2);
            staffelCollection.Add(artikel.ARLI_N_MENGE3, artikel.ARLI_N_PREISMENGE3, artikel.ARLI_N_RABATTMENGE3);
            staffelCollection.Add(artikel.ARLI_N_MENGE4, artikel.ARLI_N_PREISMENGE4, artikel.ARLI_N_RABATTMENGE4);

            input.Staffelpreise = staffelCollection;

            return input;
        }
    }
}
