﻿using WK5.Core.Models;
using WK5.Core.PageModels.Stammdaten.Lieferanten;

namespace WK5_Blazor.CoreExtensions
{
    /// <summary>
    /// Stellt eine Erweiterungsklasse für den Interop der LieferantenAnschriften zwischen WK5.Core und WK5.Blazor dar
    /// </summary>
    public static class LieferantenAnschriftExtension
    {
        /// <summary>
        /// Konvertiert eine Lieferanten Anschrift zu einem LieferantenAnschriftInput
        /// </summary>
        /// <param name="lieferantenAnschrift">Die zu konvertierende LieferantenAnschrift</param>
        /// <returns>Gibt einen <see cref="lieferantenAnschriftInput"/> zurück</returns>
        public static LieferantenAnschriftInput ToInput(this LieferantenAnschrift lieferantenAnschrift)
        {
            return new LieferantenAnschriftInput(lieferantenAnschrift.LIRE_N_NR)
            {
                Lieferantennummer = lieferantenAnschrift.LIRE_N_LIEFNR,
                Name1 = lieferantenAnschrift.LIRE_A_NAME1,
                Name2 = lieferantenAnschrift.LIRE_A_NAME2,
                Name3 = lieferantenAnschrift.LIRE_A_NAME3,
                Strasse = lieferantenAnschrift.LIRE_A_STRASSE,
                Land = lieferantenAnschrift.LIRE_A_LAND,
                Postleitzahl = lieferantenAnschrift.LIRE_A_PLZ,
                Ort = lieferantenAnschrift.LIRE_A_ORT,
                Telefon = lieferantenAnschrift.LIRE_A_TEL,
                Fax = lieferantenAnschrift.LIRE_A_FAX,
                Email = lieferantenAnschrift.LIRE_A_EMAIL,
                Ansprechpartner = lieferantenAnschrift.LIRE_A_PARTNER,
                IBAN = lieferantenAnschrift.LIRE_A_IBAN,
                BIC = lieferantenAnschrift.LIRE_A_BIC,
                Bankname = lieferantenAnschrift.LIRE_A_BANKNAME,
                Kontoinhaber = lieferantenAnschrift.LIRE_A_KONTOINHABER,
                AdressFunktion = lieferantenAnschrift.LIRE_WK5_A_FUNKTION
            };
        }
    }
}
