﻿using WK5.Core.Models;
using WK5.Core.PageModels.Stammdaten.Kunden;

namespace WK5_Blazor.CoreExtensions
{
    public static class LieferanschriftExtensions
    {
        public static LieferanschriftInput ToInput(this Lieferanschrift anschrift)
        {
            return new LieferanschriftInput(anschrift.KULA_N_NR, anschrift.WirdVerwendet)
            {
                Email = anschrift.KULA_A_EMAIL,
                Fax = anschrift.KULA_A_FAX,
                Firma = anschrift.KULA_A_NAME1,
                Land = anschrift.KULA_A_LAND,
                Name2 = anschrift.KULA_A_NAME2,
                Name3 = anschrift.KULA_A_NAME3,
                Postleitzahl = anschrift.KULA_A_PLZ,  // Postleitzahl vor Ort, weil das Input diese automatisch versucht zu ergänzen
                Ort = anschrift.KULA_A_ORT,
                Straße = anschrift.KULA_A_STRASSE,
                Telefon = anschrift.KULA_A_TEL,
                Kundennummer = anschrift.KULA_A_KUNDNR,
                Partner = anschrift.KULA_A_PARTNER,
                Hauptanschrift = anschrift.KULA_WK5_L_HAUPTANSCHRIFT,
                Notiz = anschrift.KULA_WK5_A_NOTIZ
            };
        }
    }
}
