﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core.Models;
using WK5.Core.PageModels.Stammdaten.Kunden;
using WK5.Core.Services;

namespace WK5_Blazor.CoreExtensions
{
    public static class KundenExtensions
    {
        public static async Task<KundeInput> ToInputAsync(this Kunde kunde)
        {
            var input = new KundeInput(kunde.KUND_A_NR)
            {
                Notiz = kunde.KUND_B_NOTIZ,
                Amtsgericht = kunde.KUND_WK5_A_AMTSGERICHT,
                Anrede = kunde.KUND_A_ANREDE ?? "Sehr geehrte Damen und Herren",
                Bonus = kunde.KUND_L_BONUS,
                Debitorennummer = kunde.KUND_A_DEBITORNR,
                Email = kunde.KUND_A_EMAIL ?? String.Empty, // Email muss vor Homepage gesetzt werden, da die Homepage beim setzten der E-Mail automatisch generiert wird
                Exkunde = kunde.KUND_WK5_L_EXKUNDE,
                Fax = kunde.KUND_A_FAX,
                Firma = kunde.KUND_A_NAME1,
                Frachtfrei = kunde.KUND_L_FRACHTFREI,
                Gesperrt = kunde.KUND_L_SPERRE,
                Gln = kunde.KUND_A_GLN,
                Handelsregisternummer = kunde.KUND_WK5_A_HRB,
                Handy = kunde.KUND_A_HANDY,
                Homepage = kunde.KUND_A_URL,
                KeinMailing = kunde.KUND_WK5_L_KEINMAILING,
                Kreditlimit = kunde.KUND_N_KREDITLIMIT,
                KundengruppeId = kunde.KUND_N_KUNDGRUPPE,
                Land = kunde.KUND_A_LAND,
                LieferantNummer = kunde.KUND_A_LIEFNR,
                LieferbedingungId = kunde.KUND_N_LIEFERUNG,
                MwstBerechnen = kunde.KUND_L_MWST,
                Name2 = kunde.KUND_A_NAME2,
                Name3 = kunde.KUND_A_NAME3,
                NeutraleVersandadresse = kunde.KUND_L_NEUTRALVERSAND,
                Postleitzahl = kunde.KUND_A_PLZ ?? String.Empty, // Postleitzahl vor Ort, weil das Input diese automatisch versucht zu ergänzen
                Ort = kunde.KUND_A_ORT ?? String.Empty,
                PreislisteId = kunde.KUND_N_PREISLISTNR,
                Rechnungsdruck = kunde.KUND_WK5_L_REDRUCK,
                Reminder = kunde.KUND_WK5_L_REMINDER,
                Selektionsmerkmal1 = kunde.KUND_A_SELEKTION1,
                Selektionsmerkmal2 = kunde.KUND_A_SELEKTION2,
                Selektionsmerkmal3 = kunde.KUND_A_SELEKTION3,
                Selektionsmerkmal4 = kunde.KUND_A_SELEKTION4,
                Selektionsmerkmal5 = kunde.KUND_A_SELEKTION5,
                Selektionsmerkmal6 = kunde.KUND_A_SELEKTION6,
                SperreBeiOp = kunde.KUND_L_SPERRE_OP,
                Steuernummer = kunde.KUND_A_STEUERNR,
                Strasse = kunde.KUND_A_STRASSE ?? String.Empty,
                Suchbegriff = kunde.KUND_A_SUCHCODE,
                Telefon1 = kunde.KUND_A_TEL1,
                Telefon2 = kunde.KUND_A_TEL2,
                UstId = kunde.KUND_A_USTIDNR,
                VertreterId = kunde.KUND_N_VERTRETNUMM,
                ZahlungsbedingungId = kunde.KUND_N_ZAHLUNG,
                VersandkostenManuellAnfragen = kunde.KUND_WK5_L_VERSANDWARNUNG,
                BenachrichtigenBeiFehlenderUstId = kunde.KUND_WK5_L_USTIDFEHLTGEPRUEFT,
                LetzteAbfrageUstId = kunde.UstIdLastPrüfung,
                UstIdIstGültig = kunde.IstUstIdGültig && (DateTime.Now - kunde.UstIdLastPrüfung).TotalDays <= VatService.GÜLTIGKEITSDAUER_IN_TAGEN,
                IBAN = kunde.KUND_A_IBAN ?? String.Empty,
                BIC = kunde.KUND_A_BIC ?? String.Empty,
                UstIdFirma = kunde.KUND_WK5_A_UST_NAME,
                UstIdOrt = kunde.KUND_WK5_A_UST_ORT,
                UstIdPostleitzahl = kunde.KUND_WK5_A_UST_PLZ,
                UstIdStrasse = kunde.KUND_WK5_A_UST_STRASSE,
                Mandatsreferenz = kunde.KUND_WK5_A_MANDATSREFERENZ ?? String.Empty,
                EmpfohlenVon = kunde.KUND_WK5_A_EMPFOHLEN_VON ?? String.Empty,
                MandatsAusstellungsdatum = kunde.KUND_WK5_D_AUSSTELLUNG_MANDAT,
                NurRechnungAlsPdf = kunde.NurRechnungAlsPdf,
                KeineWartungen = kunde.KeineWartungen,
                Sperrvermerk = kunde.KUND_A_SPERRVERMERK,
                LeitwegId = kunde.KUND_WK5_A_LEITWEG_ID ?? String.Empty,
                XRechnungSenden = kunde.KUND_WK5_L_XRECHNUNG    
            };
            List<Task> tasks = new List<Task>();

            tasks.Add(Task.Run(async () =>
            {
                var ansprechpartner = await Ansprechpartner.GetAnsprechpartnerAsync(kunde.KUND_A_NR).ToListAsync();
                foreach (var partner in ansprechpartner)
                {
                    input.Ansprechpartner.Add(partner.ToInput());
                }
            }));

            tasks.Add(Task.Run(async () =>
            {
                var lieferanschriften = await Lieferanschrift.GetLieferanschriftenAsync(kunde.KUND_A_NR).ToListAsync();
                foreach (var anschrift in lieferanschriften)
                {
                    input.Lieferanschriften.Add(anschrift.ToInput());
                }
            }));

            tasks.Add(Task.Run(async () =>
            {
                var rechnunganschriften = await Rechnungsanschrift.GetRechnungsanschriftenAsync(kunde.KUND_A_NR).ToListAsync();
                foreach (var anschrift in rechnunganschriften)
                {
                    input.Rechnungsanschriften.Add(anschrift.ToInput());
                }
            }));

            await Task.WhenAll(tasks);

            return input;
        }
    }
}
