﻿using Microsoft.AspNetCore.Components.Forms;
using System.IO;
using System.Threading.Tasks;

namespace WK5_Blazor.CoreExtensions
{
    public static class BrowserFileExtension
    {
        public static async Task<byte[]> ToArray(this IBrowserFile file)
        {
            byte[] buffer = new byte[file.Size];
            await using MemoryStream stream = new MemoryStream(buffer);
            await file.OpenReadStream(file.Size).CopyToAsync(stream);
            return buffer;
        }
    }
}
