﻿using WK5.Core.Models;
using WK5.Core.PageModels.Stammdaten.Kunden;


namespace WK5_Blazor.CoreExtensions
{
    public static class AnsprechpartnerExtensions
    {
        public static AnsprechpartnerInput ToInput(this Ansprechpartner partner)
        {
            return new AnsprechpartnerInput(partner.PART_N_NR)
            {
                Anrede = partner.PART_A_BRIEFANREDE ?? "Sehr geehrte Damen und Herren",
                Bereich = partner.PART_A_BEREICH,
                Email = partner.PART_A_EMAIL,
                Fax = partner.PART_A_TELEFAX,
                Mobil = partner.PART_A_MOBIL,
                Nachname = partner.PART_A_NAME,
                Telefon = partner.PART_A_TELEFON,
                Vorname = partner.PART_A_VORNAME ?? string.Empty,
                Kundennummer = partner.PART_A_KUNDNR,
                Hauptansprechpartner = partner.PART_WK5_L_HAUPT,
                Notiz = partner.PART_WK5_A_NOTIZ,
                Funktion = partner.PART_N_FUNKTION
            };
        }
    }
}
