﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Components
{
    public partial class ZeiterfassungList : IAsyncDisposable
    {
        [Parameter] public ZeitenFilter? Filter { get; set; }

        private List<Zeiterfassung> _zeiten = new List<Zeiterfassung>();
        private CancellationTokenSource _cts = new CancellationTokenSource();
        private bool _isLoading;
        private Zeiterfassung? _editZeiterfassung;
        protected override async Task OnParametersSetAsync()
        {
            await LadeAsync();
        }

        private Task AddZeiterfassungAsync()
        {
            if (Filter is not null)
            {
                _ = int.TryParse(Filter.Suchbegriff, out int belegnummer);
                if(Filter.Option is ZeitenFilterOption.Kunde)
                {
                    belegnummer = 0;
                }
                _editZeiterfassung = new Zeiterfassung
                {
                    Typ = EnumHelper.GetZeiterfassungTyp(Filter.Option),
                    Belegnummer = belegnummer,
                    Kundennummer = Filter.Kundennummer
                };
            }
            return Task.CompletedTask;
        }

        private string GetRowClass(Zeiterfassung zeiterfassung)
        {
            if(zeiterfassung.Ende == default)
            {
                return "table-danger";
            }

            return string.Empty;
        }

        private async Task LadeAsync()
        {
            if (Filter is null)
            {
                return;
            }

            using FbController2 fbController = new FbController2();
            _cts.Cancel();
            _cts.Dispose();
            _cts = new CancellationTokenSource();
            var token = _cts.Token;
            _zeiten.Clear();
            _editZeiterfassung = null;
            _isLoading = true;
            try
            {
                await foreach (var zeiterfassung in zeiterfassungService.GetZeitenAsync(Filter, fbController, token))
                {
                    _zeiten.Add(zeiterfassung);
                    StateHasChanged();
                }
            }
            catch (OperationCanceledException) { }
            _isLoading = false;

        }


        public ValueTask DisposeAsync()
        {
            _cts?.Cancel();
            _cts?.Dispose();
            return ValueTask.CompletedTask;
        }
    }
}
