﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Models;

namespace WK5_Blazor.Components
{
    public partial class ZeiterfassungErfassen
    {
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable

        public Zeiterfassung Input { get; set; } = new Zeiterfassung();

        [Parameter] public EventCallback ZeiterfassungBeendet { get; set; }

        public bool IstZeiterfassungAktiv { get; set; }

        private bool _showUnterschriftModal;
        
        protected override async Task OnParametersSetAsync()
        {
            if (!IstZeiterfassungAktiv)
            {
                using FbController2 fbController = new FbController2();

                var zeiterfassung = await zeiterfassungService.GetAktiveZeiterfassungVonMitarbeiter(Mitarbeiter.PersonalNummer, fbController);

                if (zeiterfassung is not null)
                {
                    Input = zeiterfassung;
                    IstZeiterfassungAktiv = true;
                }

                Input.ResetEnde();
            }
        }

        private Task TypChangedAsync(string typ)
        {
            Input.Kundennummer = string.Empty;
            Input.Belegnummer = 0;
            Input.Typ = typ;
            return Task.CompletedTask;
        }

        private async Task UnterschriftSpeichernAsync()
        {
            using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
            await zeiterfassungService.UpdateAsync(Input, fbController);
            await jsRuntime.ShowToast(ToastType.success, "Unterschrift wurde erfolgreich gespeichert");
        }
        private async Task NotizSpeichernAsync()
        {
            using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
            await zeiterfassungService.UpdateAsync(Input, fbController);
            await jsRuntime.ShowToast(ToastType.success, "Notiz wurde erfolgreich gespeichert");
        }

        private async Task ZeiterfassungStartenAsync()
        {
            using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
            await zeiterfassungService.CreateAsync(Input, fbController);
            IstZeiterfassungAktiv = true;
            await jsRuntime.ShowToast(ToastType.success, "Zeiterfassung wurde erfolgreich gestartet");
        }

        private async Task ZeiterfassungBeendenAsync()
        {
            Input.EndeDatum = DateTime.Now.Date;
            Input.EndeZeit = DateTime.Now;
            using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
            await zeiterfassungService.UpdateAsync(Input, fbController);
            IstZeiterfassungAktiv = false;
            Input = new Zeiterfassung();
            await jsRuntime.ShowToast(ToastType.success, "Zeiterfassung wurde erfolgreich beendet");
            await ZeiterfassungBeendet.InvokeAsync();
        }

    }
}
