﻿using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Web;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Components
{
    public partial class WarengruppeSuche
    {
        [Parameter] public EventCallback<Warengruppe> WarengruppeSelected { get; set; }

        private WarengruppenFilter Filter { get; set; } = new WarengruppenFilter();
        private List<Warengruppe> suchergebnisse = new List<Warengruppe>();

        [Parameter] public string Suchbegriff { get; set; } = String.Empty;

        private bool parametersSet = false;

        protected override async Task OnParametersSetAsync()
        {
            if (!parametersSet)
            {
                Filter.Suchbegriff = Suchbegriff;
                await Suchen();
                parametersSet = true;
            }
        }

        private async Task Suchen()
        {
            using FbController2 fbController = new FbController2();
            suchergebnisse = await warengruppenService.GetWarengruppenAsync(Filter, fbController).ToListAsync();
        }

        private void OnTableRowKeyUp(KeyboardEventArgs e, Warengruppe warengruppe)
        {
            if (e.Code == "Enter" || e.Key == "Enter")
            {
                WarengruppeSelected.InvokeAsync(warengruppe);
            }
        }
    }
}
