﻿using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Web;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Components
{
    public partial class UnterwarengruppeSuche
    {
        [Parameter] public EventCallback<Unterwarengruppe> UnterwarengruppeSelected { get; set; }
        [Parameter] public string Warengruppe { get; set; } = String.Empty;

        private UnterwarengruppenFilter Filter { get; set; } = new UnterwarengruppenFilter();
        private List<Unterwarengruppe> suchergebnisse = new List<Unterwarengruppe>();

        [Parameter] public string Suchbegriff { get; set; } = String.Empty;

        private bool parametersSet = false;

        protected override async Task OnParametersSetAsync()
        {
            if (!parametersSet)
            {
                Filter.Suchbegriff = Suchbegriff;
                Filter.Warengruppe = Warengruppe;
                await Suchen();
                parametersSet = true;
            }
        }

        private async Task Suchen()
        {
            if (!String.IsNullOrWhiteSpace(this.Warengruppe))
            {
                using FbController2 fbController = new FbController2();
                suchergebnisse = await warengruppenService.GetUnterwarengruppeAsync(Filter, fbController).ToListAsync();

            }
        }

        private void OnTableRowKeyUp(KeyboardEventArgs e, Unterwarengruppe unterwarengruppe)
        {
            if (e.Code == "Enter" || e.Key == "Enter")
            {
                UnterwarengruppeSelected.InvokeAsync(unterwarengruppe);
            }
        }
    }
}


