﻿using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Web;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Components.Suchen
{
    public partial class ZolltarifSuche
    {
        [Parameter] public EventCallback<Zolltarif> ZolltarifSelected { get; set; }

        private ZolltarifFilter Filter { get; set; } = new ZolltarifFilter();
        private List<Zolltarif> suchergebnisse = new List<Zolltarif>();

        [Parameter] public string Suchbegriff { get; set; } = String.Empty;

        protected override async Task OnParametersSetAsync()
        {
            Filter.Suchbegriff = Suchbegriff;
            await Suchen();
        }

        private async Task Suchen()
        {
            using FbController2 fbController = new FbController2();
            suchergebnisse = await zolltarifService.GetZolltarifeAsync(Filter, fbController).ToListAsync();
        }

        private void OnTableRowKeyUp(KeyboardEventArgs e, Zolltarif zolltarif)
        {
            if (e.Code == "Enter" || e.Key == "Enter")
            {
                ZolltarifSelected.InvokeAsync(zolltarif);
            }
        }
    }
}
