﻿using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Web;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Components.Suchen
{
    public partial class HerstellerSuche
    {
        [Parameter] public string Suchbegriff { get; set; } = String.Empty;
        [Parameter] public EventCallback<Hersteller> HerstellerSelected { get; set; }

        private List<Hersteller> suchergebnisse = new List<Hersteller>();

        private HerstellerFilter Filter { get; set; } = new HerstellerFilter();

        private bool parametersSet { get; set; } = false;

        protected override async Task OnParametersSetAsync()
        {
            if (!parametersSet)
            {
                Filter.Suchbegriff = Suchbegriff;
                await Suchen();
                parametersSet = true;
            }
        }

        private async Task Suchen()
        {
            suchergebnisse = await herstellerService.GetHerstellerAsync(Filter).ToListAsync();
        }

        private void OnTableRowKeyUp(KeyboardEventArgs e, Hersteller hersteller)
        {
            if (e.Code == "Enter" || e.Key == "Enter")
            {
                HerstellerSelected.InvokeAsync(hersteller);
            }
        }
    }
}
