﻿using Microsoft.AspNetCore.Components;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Components
{
    public partial class SeriennummerSuche
    {
        [Parameter] public SeriennummerFilter Filter { get; set; } = new SeriennummerFilter();
        [Parameter] public bool AllowEditFilter { get; set; } = true;

        private CancellationTokenSource _cts = new CancellationTokenSource();

        private readonly List<Seriennummer> _suchergebnisse = new List<Seriennummer>();

        [Parameter] public EventCallback<Seriennummer> SeriennummerClicked { get; set; }
        [Parameter] public EventCallback<Seriennummer> SeriennummerSelected { get; set; }
        protected override async Task OnParametersSetAsync()
        {
            await SuchenAsync();
        }

        private string GetRowClass(Seriennummer seriennummer)
        {
            if(seriennummer.Ausgeliefert)
            {
                return "table-danger";
            }
            return string.Empty;
        }

        private async Task SuchenAsync()
        {
            _cts.Cancel();
            _cts = new CancellationTokenSource();
            _suchergebnisse.Clear();
            using FbController2 fbController = new FbController2();
            await foreach (var sn in chargenService.SucheSeriennummernAsync(Filter, fbController, _cts.Token))
            {
                _suchergebnisse.Add(sn);
                StateHasChanged();
            }
        }
    }
}
