using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Forms;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Components
{
    public partial class RmaVerlaufComponent : IAsyncDisposable
    {
        [Parameter] public RmaVerlaufFilter Filter { get; set; } = new RmaVerlaufFilter();

#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        public List<RmaVerlauf> Verlauf { get; set; } = new();

        private bool _ldt;
        private CancellationTokenSource _cts = new CancellationTokenSource();
        private RmaVerlauf? _selectedRmaVerlauf;
        private EditForm? _editForm;


        protected override async Task OnParametersSetAsync()
        {
            await LadeAsync();
        }

        private async Task LadeAsync()
        {
            using FbController2 fbController = new FbController2();
            _cts.Cancel();
            _cts.Dispose();
            _cts = new CancellationTokenSource();
            var token = _cts.Token;
            _ldt = true;
            Verlauf = await rmaService.GetVerlaufAsync(Filter, fbController, token);
            _ldt = false;
        }

        private Task AddVerlaufAsync()
        {
            _selectedRmaVerlauf = new RmaVerlauf
            {
                RMVE_N_RMA_NR = Filter.RmaNummer,
                RMVE_N_LASTUSER = Mitarbeiter.PersonalNummer,
                RMVE_TIMESTAMP = DateTime.Now
            };

            return Task.CompletedTask;
        }

        private Task EditVerlaufAsync(RmaVerlauf verlauf)
        {
            _selectedRmaVerlauf = verlauf;
            return Task.CompletedTask;
        }

        private async Task SaveAsync()
        {
            if(_editForm is null || _editForm.EditContext is null || _selectedRmaVerlauf is null)
            {
                return;
            }

            using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);

            if(_editForm.EditContext.Validate())
            {
                if(_selectedRmaVerlauf.RMVE_N_ID > 0)
                {
                    await rmaService.UpdateRmaVerlaufAsync(_selectedRmaVerlauf, fbController);
                    await jsRuntime.ShowToast(ToastType.success, "RMA-Verlauf wurde erfolgreich aktualisiert.");
                }
                else
                {
                    await rmaService.CreateRmaVerlaufAsync(_selectedRmaVerlauf, fbController);
                    await jsRuntime.ShowToast(ToastType.success, "RMA-Verlauf wurde erfolgreich angelegt.");
                }
            }

            _selectedRmaVerlauf = null;
        }

        public ValueTask DisposeAsync()
        {
            _cts.Cancel();
            _cts.Dispose();
            return ValueTask.CompletedTask;
        }
    }
}