﻿using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Web;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5_Blazor.Components
{
    public partial class PreisgruppenSuche
    {
        [Parameter] public EventCallback<Preisgruppe> PreisgruppeSelected { get; set; }

        private PreisgruppenFilter Filter { get; set; } = new PreisgruppenFilter();
        private List<Preisgruppe> suchergebnisse = new List<Preisgruppe>();

        [Parameter] public string Suchbegriff { get; set; } = String.Empty;

        private bool parametersSet = false;


        protected override async Task OnParametersSetAsync()
        {
            if (!parametersSet)
            {
                Filter.Suchbegriff = Suchbegriff;
                await Suchen();
                parametersSet = true;
            }
        }

        private async Task Suchen()
        {
            using FbController2 fbController = new FbController2();
            suchergebnisse = await preisgruppenService.GetPreisgruppenAsync(Filter, fbController).ToListAsync();
        }

        private void OnTableRowKeyUp(KeyboardEventArgs e, Preisgruppe preisgruppe)
        {
            if (e.Code == "Enter" || e.Key == "Enter")
            {
                PreisgruppeSelected.InvokeAsync(preisgruppe);
            }
        }
    }
}
