﻿using Microsoft.AspNetCore.Components;
using System;


namespace WK5_Blazor.Components
{
    public partial class Pagination
    {
        //TODO: (Marvin) (.NET 7?) Sobald in .NET Verfügbar, dann sind diese Parameter alle verpflichtend.
        [Parameter] public string NavUrl { get; set; } = String.Empty;
        [Parameter] public int CurrentPageNumber { get; set; } = 1;
        [Parameter] public int ItemsProSeite { get; set; } = 30;
        [Parameter] public int TotalItems { get; set; }
        public int Seitenanzahl
        {
            get
            {
                if (TotalItems == 0 || ItemsProSeite == 0)
                {
                    return 1;
                }

                return (int)Math.Ceiling((double)TotalItems / (double)ItemsProSeite);
            }
        }

        public int StartPage
        {
            get
            {
                int startPage = CurrentPageNumber - 2;
                if (startPage < 1)
                {
                    startPage = 1;
                }

                return startPage;
            }
        }

        public int MaxPage
        {
            get
            {
                int maxPage = StartPage + 4;

                if (maxPage > Seitenanzahl)
                {
                    maxPage = Seitenanzahl;
                }

                return maxPage;
            }
        }

        public string GetUrl(int seite) => $"{NavUrl}{seite}";




    }
}
