﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core.Basis.Filter;
using WK5.Core.Services;


namespace WK5_Blazor.Components.Modals
{
    public partial class SeriennummernÜbersicht
    {
        [Parameter] public string Artikelnummer { get; set; } = string.Empty;

        private string _search { get; set; } = String.Empty;


        public bool IsLoading { get; set; } = false;

        public CancellationTokenSource CancellationToken { get; set; } = new CancellationTokenSource();
        public List<ArtikelSNVerlauf> Ergebnis { get; set; } = new List<ArtikelSNVerlauf>();
        public List<ArtikelSNVerlauf> ShowErgebnis { get; set; } = new List<ArtikelSNVerlauf>();

        protected override async Task OnParametersSetAsync()
        {

            await Suchen();
            await base.OnParametersSetAsync();
        }

        private async Task Suchen()
        {
            IsLoading = true;
            StateHasChanged();
            await Task.Delay(1);
            Ergebnis.Clear();

            CancellationToken.Cancel();
            CancellationToken = new CancellationTokenSource();

            await foreach (ArtikelSNVerlauf result in artikelService.GetSNVerlauf(Artikelnummer, CancellationToken.Token))
            {
                Ergebnis.Add(result);
                StateHasChanged();
            }

            await FilterResults();

            IsLoading = false;
        }

        private Task FilterResults()
        {
            IsLoading = true;
            StateHasChanged();
            ShowErgebnis.Clear();

            _search = _search.Trim();

            foreach (ArtikelSNVerlauf verlauf in Ergebnis)
            {
                if (verlauf.Seriennummer.Contains(_search) || String.IsNullOrWhiteSpace(_search))
                {
                    ShowErgebnis.Add(verlauf);
                    StateHasChanged();
                }
            }

            isSortedAscending = !isSortedAscending;
            if (!String.IsNullOrWhiteSpace(activeSortColumn))
            {
                SortTable(activeSortColumn);
            }

            IsLoading = false;
            return Task.CompletedTask;
        }

        private bool isSortedAscending;
        private string? activeSortColumn;
        private string sortIcon = "arrow-down";

        private void SortTable(string columnName)
        {
            if (columnName != activeSortColumn)
            {
                ShowErgebnis = ShowErgebnis.OrderBy(x => x.GetType().GetProperty(columnName)!.GetValue(x, null)).ToList();
                isSortedAscending = true;
                activeSortColumn = columnName;
            }
            else
            {
                if (isSortedAscending)
                {
                    ShowErgebnis = ShowErgebnis.OrderByDescending(x => x.GetType()!.GetProperty(columnName)!.GetValue(x, null)).ToList();
                }
                else
                {
                    ShowErgebnis = ShowErgebnis.OrderBy(x => x.GetType()!.GetProperty(columnName)!.GetValue(x, null)).ToList();
                }
                isSortedAscending = !isSortedAscending;
            }

            sortIcon = isSortedAscending ? "fas fa-arrow-up" : "fas fa-arrow-down";
        }
    }
}
