﻿using ecoDMS.Library;
using Microsoft.AspNetCore.Components;
using Serilog;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Services;

namespace WK5_Blazor.Components.Modals
{
    public partial class ArtikelBewegungenModal
    {
        
        [Parameter] public string Artikelnummer { get; set; } = String.Empty;
        public string CloseText { get; set; } = "Schließen";
        public int TotalItems { get; set; }
        private int _Seite = 1;
        public int Seite
        {
            get => _Seite;
            set
            {
                if (value <= 0)
                {
                    value = 1;
                }

                _Seite = value;
            }
        }

        public int Limit { get; set; } = 30;

        public bool IsLoading { get; set; } = false;

        public CancellationTokenSource CancellationToken { get; set; } = new CancellationTokenSource();
        public List<ArtikelBewegungsÜbersicht> Ergebnis { get; set; } = new List<ArtikelBewegungsÜbersicht>();

        protected override async Task OnParametersSetAsync()
        {
            if (Show)
            {
                await Suchen();
            }
            await base.OnParametersSetAsync();
        }

        private async Task Suchen()
        {
            if (!String.IsNullOrWhiteSpace(Artikelnummer))
            {
                IsLoading = true;
                StateHasChanged();
                Ergebnis.Clear();
                TotalItems = await artikelService.GetAnzahlArtikelBewegungen(Artikelnummer);

                CancellationToken.Cancel();
                CancellationToken = new CancellationTokenSource();

                await foreach (ArtikelBewegungsÜbersicht result in artikelService.GetArtikelBewegungenAsync(Artikelnummer, Limit, Seite, CancellationToken.Token))
                {
                    Ergebnis.Add(result);
                    StateHasChanged();
                }

                IsLoading = false;
            }
        }
        
        private async Task SeiteChanged(int page)
        {
            Seite = page;
            await Suchen();
        }

        private async Task LadeEcoDmsVorschauAsync(string rechnungsnummer)
        {
            if (!string.IsNullOrWhiteSpace(rechnungsnummer))
            {
                await ecoDmsVorschauService.GetEcoDokumentAsync(rechnungsnummer);
            }
        }
    }
}
