﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core.Basis.Filter;
using WK5.Core.Services;

namespace WK5_Blazor.Components.Modals
{
    public partial class ArtikelBestellungenModal : IHasPageFilter
    {

        [Parameter] public string Artikelnummer { get; set; } = String.Empty;
        public int TotalItems { get; set; }
        private int _Seite = 1;
        public int Seite
        {
            get => _Seite;
            set
            {
                if (value <= 0)
                {
                    value = 1;
                }

                _Seite = value;
            }
        }

        public int Limit { get; set; } = 30;

        public bool IsLoading { get; set; } = false;

        public CancellationTokenSource CancellationToken { get; set; } = new CancellationTokenSource();
        public List<ArtikelBestellungenÜbersicht> Ergebnis { get; set; } = new List<ArtikelBestellungenÜbersicht>();

        public ArtikelBestellungenFilter Filter { get; set; } = new ArtikelBestellungenFilter();

        protected override async Task OnParametersSetAsync()
        {
            Filter.Suchbegriff = Artikelnummer;
            if (Show)
            {
                await Suchen();
            }
            await base.OnParametersSetAsync();
        }

        private async Task Suchen()
        {
            if (!String.IsNullOrWhiteSpace(Artikelnummer))
            {
                IsLoading = true;
                StateHasChanged();
                Ergebnis.Clear();
                TotalItems = await artikelService.GetAnzahlArtikelBestellungen(Filter);

                Filter.Seite = Seite;

                CancellationToken.Cancel();
                CancellationToken = new CancellationTokenSource();

                await foreach (ArtikelBestellungenÜbersicht result in artikelService.GetBestellungenÜbersichtAsync(Filter, CancellationToken.Token))
                {
                    Ergebnis.Add(result);
                    StateHasChanged();
                }

                IsLoading = false;
            }
        }

        private async Task SeiteChanged(int page)
        {
            Seite = page;
            await Suchen();
        }
    }
}
