﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.PageModels.Stammdaten.Lieferanten;
using WK5.Core.Validators.Stammdaten.Lieferanten;
using WK5.Core.Models;
using WK5.Core.Basis.Erweiterungen;
using KarleyLibrary.Erweiterungen;

namespace WK5_Blazor.Components
{
    public partial class LieferantenPartnerComponent
    {
        [Parameter] public List<LieferantenPartnerInput> Partner { get; set; } = new List<LieferantenPartnerInput>();

        [Parameter] public int Lieferantennummer { get; set; }

        private LieferantenPartnerInput? _selectedPartner { get; set; }
        private LieferantenPartnerInput? StartCopy { get; set; }
        [Parameter] public bool Lädt { get; set; }

#nullable disable
        [CascadingParameter] private AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable

        private LieferantenPartnerInputValidator _partnerValidator { get; set; } = new LieferantenPartnerInputValidator();

        private bool _showDeleteModal { get; set; } = false;

        protected override Task OnParametersSetAsync()
        {
            SortPartner();
            return Task.CompletedTask;
        }
        public Task AddPartnerAsync()
        {
            LieferantenPartnerInput input = new LieferantenPartnerInput()
            {
                Lieferantennummer = Lieferantennummer
            };

            _selectedPartner = input;
            StartCopy = input.DeepCopy();
            SortPartner();
            StateHasChanged();
            return Task.CompletedTask;
        }
        private async Task SaveAsync()
        {
            if (_selectedPartner is null)
            {
                return;
            }

            if (_selectedPartner.Nummer < 0)
            {
                _selectedPartner.Nummer = (await LieferantenPartner.CreateLieferantenPartnerAsync(_selectedPartner.ToLieferantenPartner(), Mitarbeiter.PersonalNummer)).LIEP_N_NR;
                await JSRuntime.ShowToast(ToastType.success, "Lieferanten Ansprechpartner wurde angelegt.");
                Partner.Add(_selectedPartner);
            }
            else
            {
                await LieferantenPartner.UpdateLieferantenPartnerAsync(_selectedPartner.ToLieferantenPartner(), Mitarbeiter.PersonalNummer);
                await JSRuntime.ShowToast(ToastType.success, "Lieferanten Ansprechpartner wurde geändert.");
            }
            _selectedPartner = null;
            StartCopy = null;
            StateHasChanged();
        }
        private async Task DeleteAsync()
        {
            if (_selectedPartner is null || _selectedPartner.Lieferantennummer <= 0)
            {
                return;
            }

            await LieferantenPartner.DeleteLieferantenPartnerAsync(Lieferantennummer, _selectedPartner.Nummer, Mitarbeiter.PersonalNummer);
            Partner.Remove(_selectedPartner);
            _selectedPartner = null;
            StartCopy = null;
            StateHasChanged();
        }

        private Task CancelAsync()
        {
            StartCopy = null;
            _selectedPartner = null;
            return Task.CompletedTask;
        }


        

        
        private void SortPartner() => Partner = Partner.OrderByDescending(x => x.Hauptansprechpartner).ThenBy(x => x.Name).ToList();


        public string _modalTelefonnummer { get; set; } = String.Empty;
        public bool _showTelefonnummerModal { get; set; } = false;
        public Task Call(string? number)
        {
            if (number is not null)
            {
                _modalTelefonnummer = number;
                _showTelefonnummerModal = true;
                StateHasChanged();
            }
            return Task.CompletedTask;
        }

        public Task SelectPartner(LieferantenPartnerInput partner)
        {
            StartCopy = partner.DeepCopy();
            _selectedPartner = partner;
            return Task.CompletedTask;
        }

        
    }
}
