﻿using KarleyLibrary.Erweiterungen;
using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Drucken.Briefe;
using WK5.Core.Models;

namespace WK5_Blazor.Components
{
    public partial class LieferantenKontaktForm
    {
#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable
        [Parameter] public LieferantenKontakt Input { get; set; } = new();
        private LieferantenKontakt StartCopy { get; set; } = new();
        [Parameter] public EventCallback<LieferantenKontakt> OnAfterCancel { get; set; }
        [Parameter] public EventCallback<LieferantenKontakt> OnAfterEdit { get; set; }
        [Parameter] public EventCallback<LieferantenKontakt> OnAfterCreate { get; set; }
        [Parameter] public EventCallback<LieferantenKontakt> OnAfterTimeExtension { get; set; }
        [Parameter] public EventCallback<LieferantenKontakt> OnAfterDelete { get; set; }
        [Parameter] public EventCallback<LieferantenKontakt> OnAfterDownload { get; set; }
        [Parameter] public string SaveButtonMarkup { get; set; } = "<i class=\"fas fa-save\"></i>";
        [Parameter] public string ReturnButtonMarkup { get; set; } = "<i class=\"fas fa-reply\"></i>";

        public EditMode Modus { get; set; } = EditMode.Anlage;

        private bool _wiedervorlageAnlegen = true;
        public bool WiedervorlageAnlegen
        {
            get => _wiedervorlageAnlegen;
            set
            {
                _wiedervorlageAnlegen = value;

                if (Input is not null)
                {
                    Input.LFKO_L_WIEDERV_ERL = !_wiedervorlageAnlegen;
                }
            }
        }
        [Parameter] public bool ShowCancelButton { get; set; } = true;
        [Parameter] public bool ShowDownloadButton { get; set; } = true;
        [Parameter] public bool ShowDeleteButton { get; set; } = true;
        [Parameter] public bool ShowTimeExtensionButtons { get; set; } = false;
        public bool DownloadSperre { get; set; }
        public bool ShowBriefHeader { get; set; }
        private List<LieferantenPartner> Hauptansprechpartner { get; set; } = new List<LieferantenPartner>();
        private List<LieferantenPartner> NormaleAnsprechpartner { get; set; } = new List<LieferantenPartner>();

        public bool _showDeleteModal { get; set; } = false;

        protected override async Task OnParametersSetAsync()
        {
            Modus = Input.LFKO_N_ID > 0 ? EditMode.Bearbeiten : EditMode.Anlage;
            var tmpPartner = await LieferantenPartner.GetLieferantenPartnerAsync(Input.LFKO_N_LFNR).ToListAsync();

            Hauptansprechpartner = tmpPartner.Where(x => x.LIEP_L_HAUPTPARTNER).OrderBy(x => x.LIEP_A_NAME).ToList();
            NormaleAnsprechpartner = tmpPartner.Where(x => !x.LIEP_L_HAUPTPARTNER).OrderBy(x => x.LIEP_A_NAME).ToList();            

            StartCopy = Input.DeepCopy();
        }


        private async Task ExtendTime(int minutes)
        {
            if (Input is not null)
            {
                Input.LFKO_T_WIEDERV_TIME = DateTime.Now.AddMinutes(minutes);
                Input.LFKO_D_WIEDERV_DATE = DateTime.Now.AddMinutes(minutes);
                await SaveAsync();
                await OnAfterTimeExtension.InvokeAsync(Input);
            }

        }

        private async Task SaveAsync()
        {
            if (Input is not null)
            {
                using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
                switch (Modus)
                {
                    case EditMode.Anlage:
                        {
                            await lieferantenkontaktService.CreateAsync(Input, fbController);
                            await OnAfterCreate.InvokeAsync(Input);
                        }
                        break;
                    case EditMode.Bearbeiten:
                        {
                            await lieferantenkontaktService.UpdateAsync(Input, fbController);
                            await OnAfterEdit.InvokeAsync(Input);
                        }
                        break;
                    default:
                        break;
                }
            }
        }

        private async Task DeleteKontaktAsync()
        {
            if (Input is null)
            {
                return;
            }

            if (Modus is EditMode.Bearbeiten)
            {
                using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
                await lieferantenkontaktService.DeleteAsync(Input, fbController);
            }

            await OnAfterDelete.InvokeAsync(Input);
        }
        

        private async Task DownloadAsync()
        {
            if (Input is null)
            {
                return;
            }

            DownloadSperre = true;

            BriefView view = new BriefView(Input.LFKO_A_BETREFF ?? "", Input.LFKO_B_LANGNOTIZ ?? String.Empty);


            Lieferant? lief = await Lieferant.GetLieferantAsync(Input.LFKO_N_LFNR);
            LieferantenPartner? partner = await LieferantenPartner.GetLieferantenPartnerAsync(lief.LIEF_N_NR, Input.LFKO_N_PARTNER);

            if (partner is not null)
            {
                await view.SetEmpfängerAsync(partner);
            }
            else if (lief is not null)
            {
                await view.SetEmpfängerAsync(lief);
            }

            Personal? versender = await Personal.GetPersonalAsync(Mitarbeiter.PersonalNummer);
            if (versender is not null)
            {
                view.SetAbsender(versender);
            }

            BriefRegelsatz briefRegeln = new BriefRegelsatz()
            {
                ShowFooter = ShowBriefHeader,
                ShowHeader = ShowBriefHeader
            };

            PrintBrief printBrief = await PrintBrief.CreateAsync(view, briefRegeln);

            byte[] file = printBrief.PrintToMemory();

            await downloadService.DownloadFile($"Brief-{Input.LFKO_N_LFNR}.pdf", file, "application/pdf");
            await downloadService.ClearBuffers();

            DownloadSperre = false;

            await OnAfterDownload.InvokeAsync(Input);
        }

    }
}
