﻿using Microsoft.AspNetCore.Components;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Toolbelt.Blazor.HotKeys;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;
using WK5.Core.Validators;
using WK5.Core.Validators.Stammdaten.Artikeldaten;

namespace WK5_Blazor.Components
{
    public partial class LieferantenArtikelList
    {
        [Parameter] public string Artikelnummer { get; set; } = string.Empty;
        /// <summary>
        /// Wird ausgelöst, wenn ein neuer Lieferantenartikel hinzugefügt wird, ein bestehender aktualisiert und oder gelöscht wird.
        /// </summary>
        [Parameter] public EventCallback OnAction { get; set; }
        public Lieferantenartikel? SelectedLieferantenArtikel { get; set; }
        public LieferantenFilter FilterLieferanten { get; set; } = new LieferantenFilter();
        
        private List<Lieferantenartikel> _lieferantenArtikel = new List<Lieferantenartikel>();
        private LieferantenartikelValidator _validator = new LieferantenartikelValidator(new StaffelpreisCollectionValidator());
        private bool _isLoading;
        private bool _showLieferantenSucheModal;
        protected override async Task OnParametersSetAsync()
        {
            await LadeLieferantenArtikelAsync();
        }

        private async Task LadeLieferantenArtikelAsync()
        {
            using FbController2 fbController = new FbController2();
            _isLoading = true;
            _lieferantenArtikel.Clear();
            _lieferantenArtikel = await Lieferantenartikel.GetLieferantenartikelAsync(Artikelnummer, fbController).ToListAsync();
            _isLoading = false;
        }

        private Task SelectLieferantenArtikelAsync(Lieferantenartikel artikel)
        {
            SelectedLieferantenArtikel = artikel;
            
            return Task.CompletedTask;
        }

        public Task AddLieferantenArtikelAsync()
        {
            FilterLieferanten.Suchbegriff = String.Empty;
            FilterLieferanten.ShowGesperrteLieferanten = false;
            _showLieferantenSucheModal = true;
            StateHasChanged();
            return Task.CompletedTask;
        }

        private async Task LieferantSelectedAsync(Lieferant lieferant)
        {
            using FbController2 fbController = new FbController2();
            Artikel? artikel = await artikelService.GetAsync(Artikelnummer, fbController);

            if (artikel is not null)
            {
                SelectedLieferantenArtikel = new Lieferantenartikel
                {
                    ARLI_L_HAUPTLIEFERANT = !_lieferantenArtikel.Any(),
                    ARLI_A_ARTIKELNR = Artikelnummer,
                    ARLI_A_BEZ1 = artikel.Bezeichnung1,
                    ARLI_A_BEZ2 = artikel.Bezeichnung2,
                    ARLI_A_BEZ3 = artikel.Bezeichnung3,
                    ARLI_A_BEZ4 = artikel.Bezeichnung4,
                    ARLI_A_BEZ5 = artikel.Bezeichnung5,
                    ARLI_A_WAEHRUNG = "EUR",
                    ARLI_A_BESTELLNR = Artikelnummer,
                    ARLI_N_MINDESTABNAHME = artikel.ARTI_N_COLLI,
                    LieferantenName = lieferant.LIEF_A_NAME1,
                    ARLI_N_LIEFNR = lieferant.LIEF_N_NR
                };
                
            }

            _showLieferantenSucheModal = false;
        }

        private async Task ReloadAsync()
        {
            await LadeLieferantenArtikelAsync();
            await OnAction.InvokeAsync();
            SelectedLieferantenArtikel = null;
        }
    }
}
