﻿using KarleyLibrary.Erweiterungen;
using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Forms;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core;
using WK5.Core.Basis;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;
using WK5.Core.Validators;

namespace WK5_Blazor.Components
{
    public partial class LieferantenArtikelForm
    {
        [Parameter] public Lieferantenartikel? Input { get; set; }
        [Parameter] public EventCallback OnAction { get; set; }


#nullable disable
        [CascadingParameter] public AppMitarbeiter Mitarbeiter { get; set; }
#nullable enable

        public Lieferantenartikel StartCopy { get; set; } = new Lieferantenartikel();

        private StaffelpreisCollectionValidator _staffelValidator = new StaffelpreisCollectionValidator();
        private bool _showDeleteModal;
        private EditForm? _form;
        private bool _isSaving;
        

        protected override Task OnParametersSetAsync()
        {
            if (Input is not null)
            {
                StartCopy = Input.DeepCopy();
            }

            return base.OnParametersSetAsync();
        }

        private async Task RecalculatePreisAsync()
        {
            Währung? währung = await Währung.GetWährungAsync(Input.ARLI_A_WAEHRUNG);

            if (währung is null)
            {
                throw new ArgumentNullException(nameof(währung), "Es wurde keine Währung angegeben. Bitte an die Programmierung wenden!");
            }

            Input.ARLI_N_PREIS = Input.ARLI_N_WAEHRUNGSPREIS * währung.WAEH_N_WECHSELKURS;
            Input.ARLI_N_KURS = währung.WAEH_N_WECHSELKURS;
        }

        private async Task SaveAsync()
        {
            if (Input is null || _form is null || _form.EditContext is null || _isSaving || !Input.HasBeenModified(StartCopy))
            {
                return;
            }
            _isSaving = true;
            var tmp = _form.EditContext.GetValidationMessages();
            if (_form.EditContext.Validate())
            {
                using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
                Input.ARLI_D_LETZAEND = DateTime.Now;
                await Lieferantenartikel.UpdateOrCreateLieferantenArtikelAsync(Input, fbController);
                await jsRuntime.ShowToast(ToastType.success, $"Lieferantenartikel erfolgreich gespeichert.", 7000);
                await OnAction.InvokeAsync();
            }
            _isSaving = false;
        }

        private async Task DeleteAsync()
        {
            if (Input is null)
            {
                return;
            }

            using FbController2 fbController = new FbController2(Mitarbeiter.PersonalNummer);
            await Lieferantenartikel.DeleteLieferantenArtikel(Input.ARLI_A_ARTIKELNR, Input.ARLI_N_LIEFNR);
            await OnAction.InvokeAsync();
        }

        

      
 
    }
}
